<?php
/*======================================================================*\
|| #################################################################### ||
|| # SHQAWE POSTS ALERTS 
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2025-2026 SHQAWE@GMAIL.COM , Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # Visit https://www.shqawe.net for more products and styles        # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

$deleteDate = ((60 * 60 * 24) * 7) + time();


// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'spa');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('user', 'forumdisplay', 'thread');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
    'navbar',
    'USERCP_SHELL',
    'spa_list',
    'spa_spathreadbits'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_user.php');

// ######################## CHECK USER PERMISSION ########################
if (empty($vbulletin->userinfo['userid'])) {
    print_no_permission();
}

// ######################### INITIALIZE VARIABLES ########################
$vbulletin->input->clean_array_gpc('r', array(
    'do' => TYPE_STR,
));

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$navbits = construct_navbits(array(
    'usercp.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['user_control_panel']
));

if (empty($_REQUEST['do'])) {
    $_REQUEST['do'] = 'alerts';
}


// #######################################################################
if ($_REQUEST['do'] == 'alerts') {
    $spathreadbits = '';
    $show['havethreads'] = false;

    $loginuser = intval($vbulletin->userinfo['userid']);

    // Reset spacount to 0 to hide it from notifications list 
    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET spacount = 0 WHERE userid = " . $vbulletin->userinfo['userid']);

    $getthreads = $vbulletin->db->query_read("
        SELECT p.*, t.*, spa.* 
        FROM " . TABLE_PREFIX . "post AS p 
        LEFT JOIN " . TABLE_PREFIX . "thread AS t ON p.threadid = t.threadid 
        INNER JOIN " . TABLE_PREFIX . "shqawe_posts_alert AS spa ON p.postid = spa.content_id 
        WHERE spa.reciver_user_id = '$loginuser' 
        ORDER BY spa.spa_id DESC ");

    if ($vbulletin->db->num_rows($getthreads) > 0) {
        while ($thread = $vbulletin->db->fetch_array($getthreads)) {
            $thread['timeline'] = vbdate($vbulletin->options['timeformat'], $thread['lastpost']);
            $thread['dateline'] = vbdate($vbulletin->options['dateformat'], $thread['lastpost']);

            if (vbstrlen($thread['title']) > 25) {
                $thread['title'] = fetch_trimmed_title($thread['title'], 140);
            }
            // Get sender username
            $thread['alerted_username'] = fetch_userinfo($thread['sender_user_id'])['username'];
            $thread['alerted_user_avatar'] = fetch_avatar_url($thread['sender_user_id'])[0];
            // $thread['contetn_type']

            eval('$spathreadbits .= "' . fetch_template('spa_spathreadbits') . '";');
        }
        $show['havethreads'] = true;
    }


    construct_usercp_nav('spa_user_alerts');

    $navbits = construct_navbits(array(
        'usercp.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['user_control_panel'],
        '' => $vbphrase['spa_user_alerts']
    ));

    eval('$navbar = "' . fetch_template('navbar') . '";');
    eval('$HTML = "' . fetch_template('spa_list') . '";');
    eval('print_output("' . fetch_template('USERCP_SHELL') . '");');
}
