<?php
/*======================================================================*\
|| #################################################################### ||
|| # SHQAWE POSTS ALERTS ClASS
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2025-2026 SHQAWE@GMAIL.COM , Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # Visit https://www.shqawe.net for more products and styles        # ||
|| #################################################################### ||
\*======================================================================*/

require_once DIR . '/global.php';

class Spa
{
    private $vb;
    private $thread_info;
    private $new_post;
    private $post_info;
    private $contentType;

    public function __construct()
    {
        global $vbulletin;
        $this->vb = $vbulletin;
    }

    public function run($threadinfo, $newpost, $postinfo)
    {
        $this->thread_info = $threadinfo;
        $this->new_post = $newpost;
        $this->post_info = $postinfo;
        if ($this->vb->options['spa_act']) {
            $this->handleReply();
        }
    }

    public function handleAuthorReply()
    {
        $sender_user_id_author = $this->vb->userinfo['userid'];
        $reciver_user_id_author = $this->thread_info['postuserid'];
        $contetn_type = 'thread';
        $post_id = $this->new_post['postid'];

        // Check if post user not author 
        if ($sender_user_id_author != $reciver_user_id_author) {
            $this->handlePostALerts($sender_user_id_author, $reciver_user_id_author, $contetn_type, $post_id, 0);
        }
    }

    public function handleReply()
    {
        $this->handleAuthorReply();
        $thread_id = intval($this->thread_info['threadid']);
        $post_id = intval($this->new_post['postid']);
        $current_user_id = intval($this->vb->userinfo['userid']);

        $getSubscribeThread = $this->vb->db->query_read_slave("
            SELECT userid 
            FROM " . TABLE_PREFIX . "subscribethread 
            WHERE threadid = $thread_id
        ");

        // Case 1: Simple reply (no quote)
        if ((empty($this->vb->GPC['multiquoteempty']) or empty($this->vb->GPC['vbulletin_multiquote']))
            and $this->vb->GPC['specifiedpost'] == 0
        ) {

            if ($this->vb->db->num_rows($getSubscribeThread) > 0) {
                while ($pas = $this->vb->db->fetch_array($getSubscribeThread)) {
                    if ($pas['userid'] != $current_user_id) {
                        $this->handlePostALerts($current_user_id, $pas['userid'], 'reply', $post_id, 0);
                        $this->incrementAlertCount($pas['userid']);
                    }
                }
            }
        }
        // Case 2: Single quote
        elseif ((empty($this->vb->GPC['multiquoteempty']) or empty($this->vb->GPC['vbulletin_multiquote']))
            and $this->vb->GPC['specifiedpost'] == 1
        ) {

            $quoted_user_id = intval($this->post_info['userid']);

            // Alert the quoted user
            if ($quoted_user_id != $current_user_id) {
                $this->handlePostALerts($current_user_id, $quoted_user_id, 'quote', $post_id, 0, $this->post_info['postid']);
                $this->incrementAlertCount($quoted_user_id);
            }

            // Alert thread subscribers (except current user and quoted user)
            if ($this->vb->db->num_rows($getSubscribeThread) > 0) {
                while ($pas = $this->vb->db->fetch_array($getSubscribeThread)) {
                    if ($pas['userid'] != $current_user_id && $pas['userid'] != $quoted_user_id) {
                        $this->handlePostALerts($current_user_id, $pas['userid'], 'reply', $post_id, 0);
                        $this->incrementAlertCount($pas['userid']);
                    }
                }
            }
        }
        // Case 3: Multiple quotes
        elseif ((!empty($this->vb->GPC['multiquoteempty']) or !empty($this->vb->GPC['vbulletin_multiquote']))
            and $this->vb->GPC['specifiedpost'] == 0
        ) {

            $ids = $this->vb->GPC['vbulletin_multiquote'];
            $post_ids = explode(",", $ids);
            $quoted_user_ids = array();

            // Process each quoted post
            foreach ($post_ids as $quoted_post_id) {
                $quoted_post_id = intval($quoted_post_id);

                if ($quoted_post_id > 0) {
                    // Check if alert already exists for this specific quote
                    $existing_alert = $this->vb->db->query_first("
                        SELECT spa_id 
                        FROM " . TABLE_PREFIX . "shqawe_posts_alert 
                        WHERE sender_user_id = $current_user_id 
                        AND content_id = $post_id 
                        AND original_content_id = $quoted_post_id
                        AND contetn_type = 'quote'
                    ");

                    if (!$existing_alert) {
                        $reciver_user_id = $this->getUserIdByPostId($quoted_post_id);

                        if ($reciver_user_id && $reciver_user_id != $current_user_id) {
                            $this->handlePostALerts($current_user_id, $reciver_user_id, 'quote', $post_id, 0, $quoted_post_id);
                            $this->incrementAlertCount($reciver_user_id);
                            $quoted_user_ids[] = $reciver_user_id;
                        }
                    }
                }
            }

            // Alert thread subscribers (except current user and quoted users)
            if ($this->vb->db->num_rows($getSubscribeThread) > 0) {
                while ($pas = $this->vb->db->fetch_array($getSubscribeThread)) {
                    if ($pas['userid'] != $current_user_id && !in_array($pas['userid'], $quoted_user_ids)) {
                        $this->handlePostALerts($current_user_id, $pas['userid'], 'reply', $post_id, 0);
                        $this->incrementAlertCount($pas['userid']);
                    }
                }
            }
        }
    }

    public function handlePostALerts($sender_user_id, $reciver_user_id, $contetn_type, $content_id, $is_viewed = 0, $original_content_id = 0)
    {
        $sender_user_id = intval($sender_user_id);
        $reciver_user_id = intval($reciver_user_id);
        $content_id = intval($content_id);
        $is_viewed = intval($is_viewed);
        $original_content_id = intval($original_content_id);
        $contetn_type = $this->vb->db->escape_string($contetn_type);
        $spa_date = TIMENOW;
        $this->vb->db->query_write("
            INSERT INTO " . TABLE_PREFIX . "shqawe_posts_alert 
            (sender_user_id, reciver_user_id, contetn_type, content_id, original_content_id, is_viewed, spa_date) 
            VALUES ($sender_user_id, $reciver_user_id, '$contetn_type', $content_id, $original_content_id, $is_viewed, $spa_date)
        ");
    }

    private function incrementAlertCount($user_id)
    {
        $user_id = intval($user_id);
        $this->vb->db->query_write("
            UPDATE " . TABLE_PREFIX . "user 
            SET spacount = spacount + 1 
            WHERE userid = $user_id
        ");
    }

    public function getUserIdByPostId($postid)
    {
        $postid = intval($postid);
        $post = $this->vb->db->query_first("
            SELECT userid 
            FROM " . TABLE_PREFIX . "post 
            WHERE postid = $postid
        ");
        return $post ? intval($post['userid']) : 0;
    }

    public function getPostid($postid)
    {
        $postid = intval($postid);
        $post = $this->vb->db->query_first("
            SELECT threadid 
            FROM " . TABLE_PREFIX . "post 
            WHERE postid = $postid
        ");
        return $post ? intval($post['threadid']) : 0;
    }

    public function test($var)
    {
        echo '<pre>';
        print_r($var);
        exit;
    }
}
