<?php
/*======================================================================*\
|| #################################################################### ||
|| # ViewPosts v. 1.0 for vBulletin 3.0.x                             # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2004 Jordi Romkema. All Rights Reserved.              # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # http://www.jor-on.com                                            # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'viewposts');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/functions_search.php');
require_once('./includes/functions_forumlist.php');
require_once('./includes/functions_misc.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (!($permissions['forumpermissions'] & CANSEARCH))
{
	print_no_permission();
}

if (!$bbuserinfo['userid'])
{
  print_no_permission();
}

if (!$vboptions['enablesearches'])
{
	eval(print_standard_error('error_searchdisabled'));
}

// #############################################################################

$globalize = array();

// #############################################################################

if (empty($_REQUEST['do']))
{
  exec_header_redirect("$vboptions[bburl]/$vboptions[forumhome].php");
}

// #############################################################################
// get last search for this user and check floodcheck
if ($prevsearch = $DB_site->query_first("
	SELECT searchid, dateline
	FROM " . TABLE_PREFIX . "search AS search
	WHERE " . iif($bbuserinfo['userid'] == 0, "ipaddress ='" . addslashes(IPADDRESS) . "'", "userid = $bbuserinfo[userid]") . "
	ORDER BY dateline DESC LIMIT 1
"))
{
	if (TIMENOW - $prevsearch['dateline'] < $vboptions['searchfloodtime'] AND $vboptions['searchfloodtime'] != 0 AND !($permissions['adminpermissions'] & CANCONTROLPANEL) AND !can_moderate())
	{
		eval(print_standard_error('error_searchfloodcheck'));
	}
}

// #############################################################################
if ($_REQUEST['do'] == 'getunanswered')
{
	globalize($_REQUEST, array(
		'forumid' => INT
	));

	// build search hash
	$searchhash = md5($bbuserinfo['userid'] . IPADDRESS . $forumid . 'getunanswered' . $bbuserinfo['lastvisit']);

	// start search timer
	$searchtime = microtime();

	// if forumid is specified, get list of ids
	if ($forumid)
	{
		// check forum exists
		if (isset($forumcache["$forumid"]))
		{
			$display['forums'][] = $forumid;
			// check forum permissions
			if (($bbuserinfo['forumpermissions']["$forumid"] & CANVIEW) AND ($bbuserinfo['forumpermissions']["$forumid"] & CANSEARCH))
			{
				$forumids = fetch_search_forumids($forumid, 1);
			}
			else
			{
				// can not view specified forum
				$idname = $vbphrase['forum'];
				eval(print_standard_error('invalidid'));
			}
		}
		else
		{
			// specified forum does not exist
			$idname = $vbphrase['forum'];
			eval(print_standard_error('invalidid'));
		}
	}
	// forumid is not specified, get list of all forums user can view
	else
	{
		$forumids = array_keys($forumcache);
	}

	// set display terms
	$display = array(
		'words' => array(),
		'highlight' => array(),
		'common' => array(),
		'users' => array(),
		'forums' => $display['forums'],
		'options' => array(
			'starteronly' => 1,
			'childforums' => 1,
			'action' => $_REQUEST['do']
		)
	);

	// get moderator cache for forum password purposes
	cache_moderators();

	// get forum ids for all forums user is allowed to view
	foreach ($forumids AS $key => $forumid)
	{
		$fperms = &$bbuserinfo['forumpermissions']["$forumid"];
		$forum = &$forumcache["$forumid"];

		if (!($fperms & CANVIEW) OR !($fperms & CANSEARCH) OR !verify_forum_password($forumid, $forum['password'], false))
		{
			unset($forumids["$key"]);
		}
	}

	if (empty($forumids))
	{
		$idname = $vbphrase['forum'];
		eval(print_standard_error('invalidid'));
	}

	$threads = $DB_site->query("
		SELECT threadid
		FROM " . TABLE_PREFIX . "thread AS thread
		LEFT JOIN " . TABLE_PREFIX . "deletionlog AS delthread ON(delthread.primaryid = thread.threadid AND delthread.type = 'thread')
		WHERE forumid IN(" . implode(', ', $forumids) . ")
		AND thread.replycount = 0
		AND visible = 1
		AND delthread.primaryid IS NULL
		ORDER BY thread.dateline DESC
		LIMIT $vboptions[maxresults]
	");

	$orderedids = array();
	while ($thread = $DB_site->fetch_array($threads))
	{
		$orderedids[] = $thread['threadid'];
	}

	if (empty($orderedids))
	{
		eval(print_standard_error('searchnoresults', 1, 0));
	}

	$sql_ids = addslashes(implode(',', $orderedids));
	unset($orderedids);

	// end search timer
	$searchtime = fetch_microtime_difference($searchtime);

	$DB_site->query("
		REPLACE INTO " . TABLE_PREFIX . "search (userid, ipaddress, personal, forumchoice, sortby, sortorder, searchtime, orderedids, dateline, displayterms, searchhash)
		VALUES ($bbuserinfo[userid], '" . addslashes(IPADDRESS) . "', 1, '" . addslashes($forumid) . "', 'thread.dateline', 'DESC', $searchtime, '$sql_ids', " . TIMENOW . ", '" . addslashes(serialize($display)) . "', '" . addslashes($searchhash) . "')
	");
	$searchid = $DB_site->insert_id();

	$url = "search.php?$session[sessionurl]searchid=$searchid";
	eval(print_standard_redirect('search'));
}

// #############################################################################
if ($_REQUEST['do'] == 'getownthreads')
{
  // #############################################################################
	// build search hash
	$query = '';
	$searchuser = $bbuserinfo['username'];
	$exactname = 1;
	$starteronly = 1;
	$forumchoice = $forumid;
	$childforums = 1;
	$titleonly = 0;
	$showposts = 0;
	$searchdate = 0;
	$beforeafter = 'after';
	$replyless = 0;
	$replylimit = 0;
	$searchthreadid = 0;

	$searchhash = md5(TIMENOW . "||$bbuserinfo[userid]||" . strtolower($searchuser) . "||$exactname||$starteronly||$forumchoice||$childforums||$titleonly||$showposts||$searchdate||$beforeafter||$replyless||$replylimit||$searchthreadid");

	// start search timer
	$searchtime = microtime();

  // if forumid is specified, get list of ids
	if ($forumid)
	{
		// check forum exists
		if (isset($forumcache["$forumid"]))
		{
			$display['forums'][] = $forumid;
			// check forum permissions
			if (($bbuserinfo['forumpermissions']["$forumid"] & CANVIEW) AND ($bbuserinfo['forumpermissions']["$forumid"] & CANSEARCH))
			{
				$forumids = fetch_search_forumids($forumid, 1);
			}
			else
			{
				// can not view specified forum
				$idname = $vbphrase['forum'];
				eval(print_standard_error('invalidid'));
			}
		}
		else
		{
			// specified forum does not exist
			$idname = $vbphrase['forum'];
			eval(print_standard_error('invalidid'));
		}
	}
	// forumid is not specified, get list of all forums user can view
	else
	{
		$forumids = array_keys($forumcache);
	}

	// query post ids in dateline DESC order...
	$orderedids = array();

  // get moderator cache for forum password purposes
	cache_moderators();

	// get forum ids for all forums user is allowed to view
	foreach ($forumids AS $key => $forumid)
	{
		$fperms = &$bbuserinfo['forumpermissions']["$forumid"];
		$forum = &$forumcache["$forumid"];

		if (!($fperms & CANVIEW) OR !($fperms & CANSEARCH) OR !verify_forum_password($forumid, $forum['password'], false))
		{
			unset($forumids["$key"]);
		}
	}

	if (empty($forumids))
	{
		$idname = $vbphrase['forum'];
		eval(print_standard_error('invalidid'));
	}

  $threads = $DB_site->query("
    SELECT threadid
    FROM " . TABLE_PREFIX . "thread AS thread
    LEFT JOIN " . TABLE_PREFIX . "deletionlog AS delthread ON(delthread.primaryid = thread.threadid AND delthread.type = 'thread')
    WHERE forumid IN(" . implode(', ', $forumids) . ")
      AND thread.postuserid = $bbuserinfo[userid]
      AND thread.visible = 1
      AND delthread.primaryid IS NULL
    ORDER BY thread.dateline DESC
    LIMIT " . ($vboptions['maxresults'] * 2) . "
  ");
  while ($thread = $DB_site->fetch_array($threads))
  {
    $orderedids[] = $thread['threadid'];
  }
  unset($thread);
  $DB_site->free_result($threads);

  // did we get some results?
  if (empty($orderedids))
  {
    eval(print_standard_error('searchnoresults', 1, 0));
  }

	// set display terms
	$display = array(
		'words' => array(),
		'highlight' => array(),
		'common' => array(),
		'users' => array($bbuserinfo['userid'] => $bbuserinfo['username']),
		'forums' => iif($showforums, $display['forums'], 0),
		'options' => array(
			'starteronly' => 1,
      'showposts' => 0,
			'childforums' => 1,
			'action' => 'process'
		)
	);

	// end search timer
	$searchtime = fetch_microtime_difference($searchtime);

	$DB_site->query("
		REPLACE INTO " . TABLE_PREFIX . "search (userid, ipaddress, personal, searchuser, forumchoice, sortby, sortorder, searchtime, showposts, orderedids, dateline, displayterms, searchhash)
		VALUES ($bbuserinfo[userid], '" . addslashes(IPADDRESS) . "', 1, '" . addslashes($bbuserinfo['username']) . "', '" . addslashes($forumchoice) . "', 'thread.dateline', 'DESC', $searchtime, 0, '" . addslashes(implode(',', $orderedids)) . "', " . TIMENOW . ", '" . addslashes(serialize($display)) . "', '" . addslashes($searchhash) . "')
	");
	$searchid = $DB_site->insert_id();

	$url = "search.php?$session[sessionurl]searchid=$searchid";
	eval(print_standard_redirect('search'));

}
?>