<?php // PLUGIN_TITLE: Batch Import
/**************************************************************************
 *                                                                        *
 *    4images - A Web Based Image Gallery Management System               *
 *    ----------------------------------------------------------------    *
 *                                                                        *
 *             File: batch_import.php                                     *
 *        Copyright: (C) 2002 Jan Sorgalla                                *
 *            Email: jan@4homepages.de                                    *
 *              Web: http://www.4homepages.de                             *
 *    Scriptversion: 1.7                                                  *
 *                                                                        *
 *    Never released without support from: Nicky (http://www.nicky.net)   *
 *                                                                        *
 **************************************************************************
 *                                                                        *
 *    Dieses Script ist KEINE Freeware. Bitte lesen Sie die Lizenz-       *
 *    bedingungen (Lizenz.txt) fr weitere Informationen.                 *
 *    ---------------------------------------------------------------     *
 *    This script is NOT freeware! Please read the Copyright Notice       *
 *    (Licence.txt) for further information.                              *
 *                                                                        *
 *************************************************************************/

$nozip = 1;
define('IN_CP', 1);
$root_path = (eregi("\/plugins\/", $PHP_SELF)) ? "./../../" : "./../";
define('ROOT_PATH', $root_path);
require(ROOT_PATH.'admin/admin_global.php');

//-----------------------------------------------------
//--- Configuration -----------------------------------
//-----------------------------------------------------

// Path to the directory the image data are stored.
// No trailing slash!
$data_src_path = "/path/to/images/folder";

// Thumbnail options
// suffix:     Optional, can be left blank
// prefix:     Optional, can be left blank 
// subfolder:  If you images are stored in a subfolder, 
//             set the folder name here. Example: "thumbnails/"
//             Optional, can be left blank
// extensions: Valid thumbnail extensions
$thumbnail_options = array(
  "prefix"     => "",
  "suffix"     => "",  
  "subfolder"  => "",
  "extensions" => array("jpg", "JPG", "jpeg", "JPEG", "gif", "GIF", "png", "PNG")
);

// As default, the script will only copy the image files
// from your source folders to the 4images folders.
// After import you will have your image data twice on
// your server.
// If you have not enough server space set this to 1.
// Then the script will move the image files.
// Be carefully with this, your data could be lost!!!
$move_image_files = 0;

// Set this to 1 to use file modification time as date?
// Otherwise the current date will be used.
$use_image_filemtime = 1;

// Default description for each image, can be left blank
$default_image_description = "";

// Default keywords for each image, can be left blank
// Separated by spaces. Example: "keyword1 keyword2 keyword3"
$default_image_keywords = "";

// Set this to the id of the user who should be the owner of each image.
// If 0, the user id of the current logged in user will be used. That's you ;)
$default_user_id = 0;

// Default description for each category, can be left blank
$default_cat_description = "";

// Default category permissions
// AUTH_ALL   = All
// AUTH_USER  = Registered Users
// AUTH_ACL   = Private
// AUTH_ADMIN = Administrators
$auth_viewcat      = AUTH_ALL;
$auth_viewimage    = AUTH_ALL;
$auth_download     = AUTH_USER;
$auth_upload       = AUTH_USER;
$auth_directupload = AUTH_ADMIN;
$auth_vote         = AUTH_ALL;
$auth_sendpostcard = AUTH_ALL;
$auth_readcomment  = AUTH_ALL;
$auth_postcomment  = AUTH_USER;

//-----------------------------------------------------
//--- End Configuration -------------------------------
//-----------------------------------------------------

include(ROOT_PATH.'includes/search_utils.php');
$data_src_path = ereg_replace("\/$", "", $data_src_path);

$default_image_keywords = str_replace(",", " ", $default_image_keywords);
$default_image_keywords = ereg_replace("( ){2,}", " ", $default_image_keywords);

if (!empty($thumbnail_options['subfolder']) && !ereg("\/$", $thumbnail_options['subfolder'])) {
  $thumbnail_options['subfolder'] = $thumbnail_options['subfolder']."/";
}

$default_user_id = intval($default_user_id);

if ($action == "") {
  $action = "importintro";
}

function copy_image($image_src, $image_dest) {
  global $move_image_files;
  if (@is_file($image_src) && file_exists($image_src)) {
    if (file_exists($image_dest)) {
      return "File already exist";
    }
    else {
      if (copy($image_src, $image_dest)) {
        @chmod($image_dest, CHMOD_FILES);
        if ($move_image_files == 1) {
          unlink($image_src);
        }
        return "OK";
      }
      else {
        return "     ".$image_src;
      }
    }
  }
  else {
    return "    ";
  }
}

function next_step($get_options) {
  global $site_sess, $PHP_SELF;
  $page = $PHP_SELF."?action=doimport";
  foreach ($get_options as $key => $val) {
    $page .= "&".$key."=".$val;
  }
  $page = $site_sess->url($page);
  if ($get_options['autoredirect'] == 1) {
?>
<script language="javascript">
myvar = "";
timeout = 15;
function dorefresh() {
  window.status="Redirecting"+myvar;
  myvar = myvar + " .";
  timerID = setTimeout("dorefresh();", 100);
  if (timeout > 0) {
    timeout -= 1;
  }
  else {
    clearTimeout(timerID);
    window.status="";
    window.location="<?php echo $page; ?>";
  }
}
dorefresh();
<?php
}
?>
</script>
<br /><br />
<table border="0" cellspacing="0" cellpadding="1">
  <tr>
    <td class="tableseparator">
      <table width="100%" border="0" cellspacing="0" cellpadding="3">
        <tr>
          <td class="tablerow2" align="center">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="<?php echo $page; ?>"><b>  </b></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<br />
<?php
}

function get_dir($dir, $id, $pos = 0) {
  global $dir_array, $dir_parent_array, $id, $data_src_path, $thumbnail_options;

  $handle = opendir($dir);
  $folders = array();
  while ($file = @readdir($handle)) {
    if (@is_dir($dir.$file) && !eregi("^\.{1,2}$", $file) && $file != basename($thumbnail_options['subfolder'])) {
      $folders[] = $file;
    }
  }
  @closedir($handle);
  sort($folders);
  foreach ($folders as $file) {
    $id++;
    $dir_array[$id] = array(
      "cat_name" => $file,
      "cat_path" => $dir.$file,
      "cat_folder_path" => str_replace($data_src_path."/", "", $dir.$file),
      "parent_id" => $pos
    );
    $dir_parent_array[$pos][] = $id;
    get_dir($dir.$file."/", $id, $id);
  }
  return true;
}

function show_category_array($dir_parent_array, $cat = 0, $cid = 0, $depth = 1) {
  global $dir_array;
  if (!isset($dir_parent_array[$cid])) {
    return false;
  }
  echo ($cid == 0) ? "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n" : "";
  foreach ($dir_parent_array[$cid] as $val) {
    echo "<tr>\n<td align=\"right\">\n";
    echo ($val == $cat) ? "<blink><span class=\"marktext\">Scanning -&raquo;</span></blink>&nbsp;\n" : "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n";
    echo "</td><td>";
    if ($depth > 1) {
      echo str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $depth - 1)."<img src=\"".ROOT_PATH."admin/images/folder_path.gif\" alt=\"\">\n";
    }
    echo ($val == $cat) ? "<b>".$dir_array[$val]['cat_name']."</b>" : $dir_array[$val]['cat_name'];
    echo " ".$val."\n</td>\n</tr>\n";
    show_category_array($dir_parent_array, $cat, $val, $depth + 1);
  }
  echo ($cid == 0) ? "</table>\n" : "";
  return true;
}

$headinsert = "
  <script language=\"javascript\">
  function doBlink() {
    var blink = document.all.tags(\"BLINK\")
    for (var i = 0; i < blink.length; i++) {
      blink[i].style.visibility = blink[i].style.visibility == \"\" ? \"hidden\" : \"\";
    }
  }

  function startBlink() {
    if (document.all) {
      setInterval(\"doBlink()\",500)
    }
  }
  window.onload = startBlink;
  </script>
";
show_admin_header($headinsert);

if ($action == "doimport") {
  $get_options = array();
  if (isset($HTTP_GET_VARS['cat_max_id']) || isset($HTTP_POST_VARS['cat_max_id'])) {
    $cat_max_id = (isset($HTTP_GET_VARS['cat_max_id'])) ? intval($HTTP_GET_VARS['cat_max_id']) : intval($HTTP_POST_VARS['cat_max_id']);
  }
  else {
    $sql = "SELECT MAX(cat_id) as max_id 
          FROM ".CATEGORIES_TABLE;
    $row = $site_db->query_firstrow($sql);
    $cat_max_id = (!empty($row['max_id'])) ? $row['max_id'] : 0;
  }

  if (isset($HTTP_GET_VARS['cat']) || isset($HTTP_POST_VARS['cat'])) {
    $cat = (isset($HTTP_GET_VARS['cat'])) ? intval($HTTP_GET_VARS['cat']) : intval($HTTP_POST_VARS['cat']);
  }
  else {
    $cat = $cat_max_id + 1;
  }

  if (isset($HTTP_GET_VARS['batchstart']) || isset($HTTP_POST_VARS['batchstart'])) {
    $batchstart = (isset($HTTP_GET_VARS['batchstart'])) ? intval($HTTP_GET_VARS['batchstart']) : intval($HTTP_POST_VARS['batchstart']);
  }
  else {
    $batchstart = 0;
  }

  if (isset($HTTP_GET_VARS['batchsize']) || isset($HTTP_POST_VARS['batchsize'])) {
    $batchsize = (isset($HTTP_GET_VARS['batchsize'])) ? intval($HTTP_GET_VARS['batchsize']) : intval($HTTP_POST_VARS['batchsize']);
    if (!$batchsize) {
      $batchsize = 25;
    }
  }
  else {
    $batchsize = 25;
  }

  if (isset($HTTP_GET_VARS['autoredirect']) || isset($HTTP_POST_VARS['autoredirect'])) {
    $autoredirect = (isset($HTTP_GET_VARS['autoredirect'])) ? intval($HTTP_GET_VARS['autoredirect']) : intval($HTTP_POST_VARS['autoredirect']);
  }
  else {
    $autoredirect = 0;
  }

  if (!is_dir($data_src_path)) {
    echo "<p><b class=\"marktext\">       (data source)    \"$data_src_path\"  !</b></p>";
    show_text_link($lang['back'], $PHP_SELF);
    show_admin_footer();
    exit;
  }

  @set_time_limit(120);
  $dir_array = array();
  $dir_parent_array = array();

  $id = $cat_max_id;
  get_dir($data_src_path."/", $cat_max_id);
  $num_cats = sizeof($dir_array);
  echo "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"right\"><tr><td>";
  show_category_array($dir_parent_array, $cat);
  echo "</td></tr></table>";

  $dir = $dir_array[$cat]['cat_path']."/";
  $files = array();
  $handle = opendir($dir);
  while ($file = @readdir($handle)) {
    if (@is_file($dir.$file)) {
      if (!empty($thumbnail_options['prefix']) && preg_match("/^".$thumbnail_options['prefix']."/", $file)) {
        continue;
      }
      if (!empty($thumbnail_options['suffix']) && preg_match("/".$thumbnail_options['suffix']."\.([a-z]{1,4})$/", $file)) {
        continue;
      }
      $files[] = $file;
    }
  }
  @closedir($handle);
  sort($files);

  $total = sizeof($files);

  $batchend = $batchstart + $batchsize - 1;
  if ($batchend >= $total - 1) {
    $batchend = $total - 1;
  }

  echo "<p><b>".$total."</b>   <b>".$dir_array[$cat]['cat_name']."</b>.";
  echo ($total > 0) ? "   <b>".($batchstart + 1)."</b> to <b>".($batchend + 1)."</b></p>" : "</p>";

  if ($batchstart == 0) {
    echo "  <b>".$dir_array[$cat]['cat_name']."</b>";
    if (isset($dir_array[$dir_array[$cat]['parent_id']]['cat_name'])) {
      echo " ( : <b>".$dir_array[$dir_array[$cat]['parent_id']]['cat_name']."</b>)";
    }
    echo " ... ";
    flush();
    @set_time_limit(120);

    $cat_name      = str_replace("_", " ", $dir_array[$cat]['cat_name']);
    $cat_parent_id = $dir_array[$cat]['parent_id'];

    $sql = "SELECT cat_order 
            FROM ".CATEGORIES_TABLE." 
            WHERE cat_parent_id = $cat_parent_id 
            ORDER BY cat_order DESC 
            LIMIT 1";
    $cat_order = $site_db->query_firstrow($sql);

    $sql = "INSERT INTO ".CATEGORIES_TABLE." 
            (cat_id, cat_name, cat_description, cat_parent_id, cat_order, auth_viewcat, auth_viewimage, auth_download, auth_upload, auth_directupload, auth_vote, auth_sendpostcard, auth_readcomment, auth_postcomment) 
            VALUES 
            ($cat, '".addslashes($cat_name)."', '".addslashes($default_cat_description)."', $cat_parent_id, ".($cat_order['cat_order'] + 10).", $auth_viewcat, $auth_viewimage, $auth_download, $auth_upload, $auth_directupload, $auth_vote, $auth_sendpostcard, $auth_readcomment, $auth_postcomment)";
    $result = $site_db->query($sql);
    $cat_id = $site_db->get_insert_id();

    if ($result && $cat_id) {
      $oldumask = umask(0);
      mkdir(MEDIA_PATH."/".$cat_id, CHMOD_DIRS);
      mkdir(THUMB_PATH."/".$cat_id, CHMOD_DIRS);
      umask($oldumask);
      echo "<b></b><br><br>";
    }
    else {
      echo "<b class='marktext'>FAILED</b><br><br>";
    }
  }

  if ($total > 0) {
    for ($i = $batchstart; $i <= $batchend; $i++) {
      $file = $files[$i];
      echo "<b>".($i + 1).".</b>  <b>".$file."</b><br />";
      flush();
      @set_time_limit(120);
      $output = "";
      
      $uid = ($default_user_id > 0) ? $default_user_id : $user_info['user_id'];
      
      $image_date = ($use_image_filemtime) ? filemtime($dir_array[$cat]['cat_path']."/".$file) : time();

      $image_votes = 0;
      $image_rating = '0.00';
      $image_hits = 0;

      //Copy Images
      $output .= "<b> :</b> ";
      $msg = copy_image($dir_array[$cat]['cat_path']."/".$file, MEDIA_PATH."/".$cat."/".$file);
      $output .= $msg."<br />";

      if ($msg != "OK") {
        echo $output."Skipping.....<br /><br />";
        continue;
      }

      $file_name = get_file_name($file);

      $new_thumb_name = "";
      if (!empty($thumbnail_options['prefix']) || !empty($thumbnail_options['suffix']) || !empty($thumbnail_options['subfolder'])) {
        $output .= "<b> :</b> ";
        foreach ($thumbnail_options['extensions'] as $extension) {
          $thumb_name = $thumbnail_options['prefix'].$file_name.$thumbnail_options['suffix'].".".$extension;
          if (file_exists($dir_array[$cat]['cat_path']."/".$thumbnail_options['subfolder'].$thumb_name)) {
            $msg = copy_image($dir_array[$cat]['cat_path']."/".$thumbnail_options['subfolder'].$thumb_name, THUMB_PATH."/".$cat."/".$file_name.".".$extension);
            $new_thumb_name = $file_name.".".$extension;
            $output .= $msg."<br />";
            break;
          }
        }
      }
      $output .= ($new_thumb_name == "") ? "    <br />" : "";

      $image_name = str_replace("_", " ", $file_name);

      $output .= "<b> :</b> ".htmlspecialchars($image_name)."<br>";
      $output .= "<b>:</b> ".format_date($config['date_format']." ".$config['time_format'], $image_date)."<br>";

      $sql = "INSERT INTO ".IMAGES_TABLE." 
              (cat_id, user_id, image_name, image_description, image_keywords, image_date, image_active, image_media_file, image_thumb_file, image_download_url, image_allow_comments, image_comments, image_downloads, image_votes, image_rating, image_hits) 
              VALUES 
              ($cat, $uid, '".addslashes($image_name)."', '".addslashes($default_image_description)."', '".addslashes($default_image_keywords)."', $image_date, 1, '$file', '$new_thumb_name', '', 1, 0, 0, $image_votes, '$image_rating', $image_hits)";
      $result = $site_db->query($sql);
      $image_id = $site_db->get_insert_id();
 
      if (!empty($default_image_description)) {
        $image_description = $default_image_description;
      }

      if (!empty($default_image_keywords)) {
        $image_keywords = $default_image_keywords;
      }

      if ($result) {
        $search_words = array();
        foreach ($search_match_fields as $image_column => $match_column) {
          if (isset(${$image_column})) {
            $search_words[$image_column] = stripslashes(${$image_column});
          }
        }
        add_searchwords($image_id, $search_words);
      }
      echo $output."<br />";
    }
  }

  if ((($cat - $cat_max_id) < $num_cats) || $batchend < $total - 1) {
    if ($batchend < $total - 1) {
      $batchstart = $batchend + 1;
    }
    else {
      $batchstart = 0;
      $cat++;
    }

    $get_options['cat_max_id']   = $cat_max_id;
    $get_options['cat']          = $cat;
    $get_options['batchstart']   = $batchstart;
    $get_options['batchsize']    = $batchsize;
    $get_options['autoredirect'] = $autoredirect;
    next_step($get_options);
    show_text_link("Cancel", $PHP_SELF);
  }
  else {
    echo "<p><b>    !</b></p>";
    show_text_link("Back", $PHP_SELF);
  }
}

if ($action == "importintro") {
  show_form_header($PHP_SELF, "doimport");
  show_table_header(" ", 2);
  show_custom_row("Data Source Path", $data_src_path);

  show_input_row("      ", "batchsize", 50, 15);
  show_radio_row("        ", "autoredirect", 0);
  show_form_footer($lang['submit'], $lang['reset'], 2);
}

show_admin_footer();
?>
