<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 2.9                                                //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Retail Price        : $80.00 United States Dollars                       //
//  WebForum Price      : $00.00 Always 100% Free                            //
//  Supplied by         : South [WTN]                                        //
//  Nullified By        : CyKuH [WTN]                                        //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2003 Belchior Foundry                   //
//***************************************************************************//
define('IN_VCARD', true);

function FilledArc(&$im, $CenterX, $CenterY, $DiameterX, $DiameterY, $Start, $End, $line_color, $fill_color='none') {

	ImageArc($im, $CenterX, $CenterY, $DiameterX, $DiameterY, $Start, $End, $line_color);
	$x = $CenterX + (cos(deg2rad($Start)) * ($DiameterX / 2));
	$y = $CenterY + (sin(deg2rad($Start)) * ($DiameterY / 2));
	ImageLine($im, $x, $y, $CenterX, $CenterY, $line_color);
	$x = $CenterX + (cos(deg2rad($End)) * ($DiameterX / 2));
	$y = $CenterY + (sin(deg2rad($End)) * ($DiameterY / 2));
	ImageLine($im, $x, $y, $CenterX, $CenterY, $line_color);
	if ($fill_color != 'none')
	{
		if (($End - $Start) > 0.5)
		{
			$x = $CenterX + (cos(deg2rad(($Start + $End) / 2)) * ($DiameterX / 4)); 
			$y = $CenterY + (sin(deg2rad(($Start + $End) / 2)) * ($DiameterY / 4)); 
			ImageFillToBorder($im, $x, $y, $line_color, $fill_color);
		}
	}
}

function chart_pie($data, $width, $height, $CenterX, $CenterY, $DiameterX, $DiameterY, $MinDisplayPct, $DisplayColors, $BackgroundColor, $LineColor, $Legend, $FontNumber, $SortData=TRUE) {

	if ($Legend) {
		$DiameterX = $DiameterY;
		$CenterX   = $width - $CenterY;
	}
	if ($im = @ImageCreate($width, $height))
	{
		$background_color = ImageColorAllocate($im, hexdec(substr($BackgroundColor, 0, 2)), hexdec(substr($BackgroundColor, 2, 2)), hexdec(substr($BackgroundColor, 4, 2)));
		$line_color = ImageColorAllocate($im, hexdec(substr($LineColor, 0, 2)), hexdec(substr($LineColor, 2, 2)), hexdec(substr($LineColor, 4, 2)));
		$fillcolorsarray = explode(';', $DisplayColors);
		for ($i = 0; $i < count($fillcolorsarray); $i++)
		{
			$fill_color[]= ImageColorAllocate($im, hexdec(substr($fillcolorsarray["$i"], 0, 2)), hexdec(substr($fillcolorsarray["$i"], 2, 2)), hexdec(substr($fillcolorsarray["$i"], 4, 2)));
			$label_color[]= ImageColorAllocate($im, hexdec(substr($fillcolorsarray["$i"], 0, 2)) * 0.8, hexdec(substr($fillcolorsarray["$i"], 2, 2)) * 0.8, hexdec(substr($fillcolorsarray["$i"], 4, 2)) * 0.8);
		}
		$TotalArrayValues = array_sum($data);
		if ($SortData){ arsort($data); }
		$Start = 0;
		$valuecounter = 0;
		$ValuesSoFar = 0;
		foreach ($data as $key => $value) {
			$ValuesSoFar += $value;
			if (!$SortData || (($value / $TotalArrayValues) > $MinDisplayPct))
			{
				$End = ceil(($ValuesSoFar / $TotalArrayValues) * 360);
				FilledArc($im, $CenterX, $CenterY, $DiameterX, $DiameterY, $Start, $End, $line_color, $fill_color[$valuecounter % count($fill_color)]);
				if($Legend)
				{
					ImageString($im, $FontNumber, 5, round((ImageFontHeight($FontNumber) * .5) + ($valuecounter * 1.5 * ImageFontHeight($FontNumber))), $key.' ('.number_format(($value / $TotalArrayValues) * 100, 1).'%)', $label_color[$valuecounter % count($label_color)]);
				}
				$Start = $End;
			}else{
				$End = 360;
				if ((($TotalArrayValues - $ValuesSoFar) / $TotalArrayValues) > 0.0025)
				{
					FilledArc($im, $CenterX, $CenterY, $DiameterX, $DiameterY, $Start, $End, $line_color, $line_color);
				}
				if ($Legend)
				{
					ImageString($im, $FontNumber, 5, round((ImageFontHeight($FontNumber) * .5) + ($valuecounter * 1.5 * ImageFontHeight($FontNumber))), 'Other ('.number_format((($TotalArrayValues - $ValuesSoFar) / $TotalArrayValues) * 100, 1).'%)', $line_color);
				}
				break;
			}
			$valuecounter++;
		}
		if(@function_exists('ImagePng')){
			@header("Content-type: image/png");    //if your php support JPEG
			ImagePng($im);
		}else{
			@header("Content-type: image/jpeg");    //if your php support JPEG
			ImageJPEG($im);
		}
		ImageDestroy($im);
		return true;
	}else{
		 echo 'Cannot Initialize new GD image stream';
		 return false;
	}
}


if(empty($HTTP_GET_VARS['type']))
{
	error_reporting(E_ERROR | E_WARNING | E_PARSE);
	$title = $HTTP_GET_VARS['title'];
	$sval = $HTTP_GET_VARS['sval'];
	$img_width	= 350;
	$img_height	= 200;
	$title_font	= 5;
	
	$im = imagecreate($img_width,$img_height);
	$background = imageColorAllocate($im,80,80,80);
	$textcolor = imageColorAllocate($im,255,207,95);
	$barbground	= imageColorAllocate($im,239,239,239);
	$barcolor = imageColorAllocate($im,144,144,255);
	ImageString($im,$title_font,($img_width-ImageFontWidth($title_font)*strlen($title))/2,0,$title,$textcolor);
	imagefilledrectangle($im,25,20,$img_width-10,$img_height-10,$barbground);
	$valeurs 	= explode(";",$sval);
	$img_width_barre = (int)(($img_width-22)/(1.5*sizeof($valeurs)+0.5));
	for ($i=0; $i<sizeof($valeurs); $i++)
	{
		if ($valeurs[$i] > $max)
		{
	   		$max = $valeurs[$i];
		}
	}
	
	for ($i=0; $i<sizeof($valeurs); $i++)
	{
		$x = 25+(int)($img_width_barre*(0.5+$i*1.5));
		$img_height_barre = (int)(($valeurs[$i]*($img_height-40))/$max);
		imagefilledrectangle($im,$x,$img_height-15-$img_height_barre,$x+$img_width_barre,$img_height-15,$barcolor);
		if ($valeurs[$i] == $max)
		{
			ImageString($im,2,4,($img_height-15-$img_height_barre)-(ImageFontHeight(2)/2),$valeurs[$i],$textcolor);
			imageline($im,20,$img_height-15-$img_height_barre,$img_width-2,$img_height-15-$img_height_barre,$background);
	 	}
	 	if (($i % 2)==0)
		{
			ImageString($im,1,$x,$img_height-9,$i,$textcolor);
		}
	}
	ImageString($im,2,3,0,'hits',$textcolor);
	ImageString($im,-10,320,191,'Hour',$textcolor);
	
	if(@function_exists('ImagePng')){
		@header("Content-type: image/png");    //if your php support JPEG
		ImagePng($im);
	}else{
		@header("Content-type: image/jpeg");    //if your php support JPEG
		ImageJPEG($im);
	}
	ImageDestroy($im);
	
	//@header("Pragma: no-cache");
	//header("Cache-Control: no-cache, must-revalidate"); 
}
if($HTTP_GET_VARS['type']=='pie')
{
	if (!empty($HTTP_GET_VARS['data'])){
		$data = (is_array($HTTP_GET_VARS['data']))? $HTTP_GET_VARS['data']: unserialize(stripslashes($HTTP_GET_VARS['data'])) ;
	}else{
		if(!isset($demomode)){
			srand(time());
			for ($i = 1; $i < 15; $i++)	{ $data['Demo '.$i] = rand(0, 1000);}
		}else{
			$data = array('NO DATA'=>1);
		}
	}
	$width           = (!empty($HTTP_GET_VARS['width']) ? $HTTP_GET_VARS['width'] : 500);
	$height          = (!empty($HTTP_GET_VARS['height']) ? $HTTP_GET_VARS['height'] : 300);
	$CenterX         = round($width / 2);
	$CenterY         = round($height / 2);
	$DiameterX       = round($width * 0.75);
	$DiameterY       = round($height * 0.75);
	$MinDisplayPct   = 0.01;
	$DisplayColors   = 'FF9900;FFFF00;99FF00;FF0033;FF00CC;00CC00;990099;999999;CCFFFF;3300FF;00CCFF;FFCCFF;003366;FF00FF;666666;000000';
	$BackgroundColor = 'ffffff';
	$LineColor       = '000000';
	$Legend          = true;
	$FontNumber      = 3;
	$SortData        = true;
	if (($width > 819) || ($height > 819) || ($width <= 0) || ($height <= 0)) {
		die('Image size limited to 819 x 819 for safety reasons');
	}
	// echo '<img src="statschart.php?data='.urlencode(serialize($data)).'">';
	chart_pie($data, $width, $height, $CenterX, $CenterY, $DiameterX, $DiameterY, $MinDisplayPct, $DisplayColors, $BackgroundColor, $LineColor, $Legend, $FontNumber, $SortData);
}

?>