<?php
/**************************************************************************
 *                                                                        *
 *    4images - A Web Based Image Gallery Management System               *
 *    ----------------------------------------------------------------    *
 *                                                                        *
 *             File: images.php                                           *
 *        Copyright: (C) 2002 Jan Sorgalla                                *
 *            Email: jan@4homepages.de                                    *
 *              Web: http://www.4homepages.de                             *
 *    Scriptversion: 1.7                                                  *
 *    File Version: 3.7.1 (by V@no)                                       *
 *                                                                        *
 *    Never released without support from: Nicky (http://www.nicky.net)   *
 *                                                                        *
 **************************************************************************
 *                                                                        *
 *    Dieses Script ist KEINE Freeware. Bitte lesen Sie die Lizenz-       *
 *    bedingungen (Lizenz.txt) fr weitere Informationen.                 *
 *    ---------------------------------------------------------------     *
 *    This script is NOT freeware! Please read the Copyright Notice       *
 *    (Licence.txt) for further information.                              *
 *                                                                        *
 *************************************************************************/

define('IN_CP', 1);
define('ROOT_PATH', './../');
require('admin_global.php');

//------ Settings ------------

/*set $big variable with the name of your "big" folder for "big" images (no trailing slashes!)*/
//$big = "";
$big = "big";
/*set $backup variable with the path to your backup dir (no trailing slashes!)*/
$backup = defined('BACKUPDIR') ? BACKUPDIR : "";
//$backup = "";
//$backup = BACKUPDIR; 
$thumbsize = 48;
//quick edit description and keywords field size
$cols = 30;
$rows = 3;
$target = true; //Open links to edit/delete a single image in a new window? (true or false)

//----- End Settings ---------

$lang['changeowner'] = "Change owner";
$lang['copy'] = "Copy";
$lang['move'] = "Move";
$lang['save'] = "Save";
$lang['big_not_found'] = "No Original size (big) Found";
$lang['orig_not_found'] = "No Original Found";
$lang['copy_file_error'] = "Copy error. (File {src} to {des}) Please check the directory permissions.";
$lang['copy_success'] = "Image copied";
$lang['copy_file_error'] = "<b>Error copying image</b> {src} (from category ID: {from} to {to})";
$lang['skiped'] = "skiped";
$lang['in_cat_id'] = "in category ID";
$lang['error_del_big'] = "Error deleting \"big\" file";
$lang['error_del_backup'] = "Error deleting \"backup\" file";
$lang['src_des_same'] = "source and destination are the same";
$lang['moved'] = "Image moved";
$lang['move_error'] = "Error moving image";
$lang['owner_error'] = "Error changing owner";
$lang['no_user_select'] = "No user selected";
$lang['owner_success'] = "Owner changed successfuly";


include(ROOT_PATH.'includes/search_utils.php');

// Start Upload
include(ROOT_PATH.'includes/upload.php');
$site_upload = new Upload();

if ($action == "") {
  $action = "modifyimages";
}
$owner = "";
function get_resize2($file, $dim){
  $file_info = @getimagesize($file);
  $width = $file_info[0];
  $height = $file_info[1];
  if ($width && $height) {
    if ($width > $dim || $height > $dim) {
      @$ratio = $width / $height;
      if ($ratio > 1) {
        $new_width = $dim;
        $new_height = round(($dim/$width) * $height);
      }else {
        $new_width = round(($dim/$height) * $width);
        $new_height = $dim;
      }
    }else{
      $new_width = $width;
      $new_height = $height;
    }
  }else{
    $new_width = $dim;
    $new_height = $dim;
  }
  return array($new_width, $new_height, $file_info);
}

function delete_images($image_ids, $delfromserver = 1) {
  global $site_db, $lang, $big, $backup;
  if (empty($image_ids)) {
    echo $lang['no_search_results'];
    return false;
  }
  $error_log = array();
  echo "<br />";
  $sql = "SELECT i.image_id, i.cat_id, i.user_id, i.image_name, i.image_media_file, i.image_thumb_file, l.lightbox_image_ids
          FROM ".IMAGES_TABLE." i
          LEFT JOIN ".LIGHTBOXES_TABLE." l ON (l.user_id = i.user_id)
          WHERE i.image_id IN ($image_ids)";
  $image_result = $site_db->query($sql);
  while ($image_row = $site_db->fetch_array($image_result)) {
    if ($image_row['user_id'] != GUEST)
    {
      $lightbox_array = explode(" ",$image_row['lightbox_image_ids']);
      foreach ($lightbox_array as $key => $val) {
        if ($val == $image_row['image_id']) {
          unset($lightbox_array[$key]);
        }
      }
      $lightbox_image_ids = trim(implode(" ", $lightbox_array));
      $sql = "UPDATE ".LIGHTBOXES_TABLE." 
              SET lightbox_image_ids = '".$lightbox_image_ids."' 
              WHERE user_id = ".$image_row['user_id'];
      $site_db->query($sql);
    }
    $sql = "DELETE FROM ".IMAGES_TABLE."
            WHERE image_id = ".$image_row['image_id'];
    if ($site_db->query($sql)) {
      echo "<b>".$lang['image_delete_success']."</b> ".$image_row['image_name']." (ID: ".$image_row['image_id'].")<br />\n";
    }
    else {
      $error_log[] = "<b>".$lang['image_delete_error']."</b> ".$image_row['image_name']." (ID: ".$image_row['image_id'].")<br />";
    }

    if ($delfromserver) {
      if (!is_remote($image_row['image_media_file']) && !is_local_file($image_row['image_media_file'])) {
        if (@unlink(MEDIA_PATH."/".$image_row['cat_id']."/".$image_row['image_media_file'])) {
          echo "&nbsp;&nbsp;".$lang['file_delete_success']." (".$image_row['image_media_file'].")<br />\n";
        }
        else {
          $error_log[] = "<b>".$lang['file_delete_error']." (".$image_row['image_media_file'].")<br />";
        }
      }
      if (!empty($image_row['image_thumb_file']) && !is_remote($image_row['image_thumb_file']) && !is_local_file($image_row['image_thumb_file'])) {
        if (@unlink(THUMB_PATH."/".$image_row['cat_id']."/".$image_row['image_thumb_file'])) {
          echo "&nbsp;&nbsp;".$lang['thumb_delete_success']." (".$image_row['image_thumb_file'].")<br />\n";
        }
        else {
          $error_log[] = "<b>".$lang['thumb_delete_error']." (".$image_row['image_thumb_file'].")<br />\n";
        }
      }
      if ($big)
      {
        if (@unlink(MEDIA_PATH."/".$image_row['cat_id']."/".$big."/".$image_row['image_media_file'])) {
          echo "&nbsp;&nbsp;".$lang['file_delete_success']." (".$big."/".$image_row['image_media_file'].")<br />\n";
        }else {
          echo "&nbsp;&nbsp;".$lang['big_not_found']." <br />\n";
        }
      }
      if ($backup)
      {
  			if (@unlink($backup."/".$image_row['cat_id']."/".$image_row['image_media_file'])) {
          echo "&nbsp;&nbsp;".$lang['file_delete_success']." (".$backup."/".$image_row['image_media_file'].")<br />\n";
        }else {
          echo "&nbsp;&nbsp;".$lang['orig_not_found']." <br />\n";
        }
      }
    }

    if (!empty($user_table_fields['user_comments'])) {
      $sql = "SELECT user_id
              FROM ".COMMENTS_TABLE."
              WHERE image_id = ".$image_row['image_id']." AND user_id <> ".GUEST;
      $result = $site_db->query($sql);

      while ($row = $site_db->fetch_array($result)) {
        $sql = "UPDATE ".USERS_TABLE."
                SET ".get_user_table_field("", "user_comments")." = ".get_user_table_field("", "user_comments")." - 1
                WHERE ".get_user_table_field("", "user_id")." = ".$row['user_id'];
        $site_db->query($sql);
      }
    }

    $sql = "DELETE FROM ".COMMENTS_TABLE."
            WHERE image_id = ".$image_row['image_id'];
    if ($site_db->query($sql)) {
      echo $lang['comments_delete_success']."<br />\n";
    }
    else {
      $error_log[] = "<b>".$lang['comments_delete_success']."</b> ".$image_row['image_name'].", (ID: ".$image_row['image_id'].")<br />\n";
    }
    echo "<br />\n";
  }
  remove_searchwords($image_ids);
  return $error_log;
}

function do_copy($image_media_file, $image_thumb_file = "", $from_cat = 0, $to_cat = 0, $media = 1) {
  global $config, $big, $error_log, $lang, $big, $backup;
  if ($media) {
    if (is_remote($image_media_file)) {
      return $image_media_file;
    }
    $ok = 0;
    $new_file = $image_media_file;
    $image_src = ($from_cat != -1) ? MEDIA_PATH.(($from_cat != 0) ? "/".$from_cat : "") : MEDIA_TEMP_PATH;
    $image_dest = ($to_cat != -1) ? MEDIA_PATH.(($to_cat != 0) ? "/".$to_cat : "") : MEDIA_TEMP_PATH;
    $image_src_file = $image_src."/".$image_media_file;
    if ($big && file_exists((($from_cat != -1) ? MEDIA_PATH.(($from_cat != 0) ? "/".$from_cat : "") : MEDIA_TEMP_PATH)."/".$big."/".$image_row['image_media_file'])) {
      $image_src_big = (($from_cat != -1) ? MEDIA_PATH.(($from_cat != 0) ? "/".$from_cat : "") : MEDIA_TEMP_PATH)."/".$big;
      $image_dest_big = (($to_cat != -1) ? MEDIA_PATH.(($to_cat != 0) ? "/".$to_cat : "") : MEDIA_TEMP_PATH)."/".$big;
      $image_src_file_big = $image_src_big."/".$image_media_file;
    }else{
      $image_src_big = "";
      $image_dest_big = "";
      $image_src_file_big = "";
    }
    if ($backup && file_exists($backup."/".(($from_cat != 0 && $from_cat != -1) ? $from_cat : ""))) {
      $image_src_backup =  $backup."/".(($from_cat != 0 && $from_cat != -1) ? $from_cat : "");
      $image_dest_backup = $backup."/".(($to_cat != 0 && $to_cat != -1) ? $to_cat : "");
      $image_src_file_backup = $image_src_backup."/".$image_media_file;
    }
    else
    {
      $image_src_backup = "";
      $image_dest_backup = "";
      $image_src_file_backup = "";
    }
/*
    switch ($config['upload_mode']) {
    case 1: // overwrite mode
      if (file_exists($image_src."/".$image_media_file)) {
        if (file_exists($image_dest."/".$image_media_file)) {
          @unlink($image_dest."/".$image_media_file);
        }
        $ok = copy($image_src."/".$image_media_file, $image_dest."/".$image_media_file);
      }
      break;

    case 2: // create new with incremental extention
*/
      if (file_exists($image_src."/".$image_media_file)) {
        $file_extension = get_file_extension($image_media_file);
        $file_name = get_file_name($image_media_file);
        $n = 2;
        $copy = "";
        while (file_exists($image_dest."/".$file_name.$copy.".".$file_extension)) {
          $copy = "_".$n;
          $n++;
        }
        $new_file = $file_name.$copy.".".$file_extension;
        $ok = copy($image_src_file, $image_dest."/".$new_file);
        if ($big)
        {
          @copy($image_src_file_big, $image_dest_big."/".$new_file);
        }
        if ($backup)
        {
          @copy($image_src_file_backup, $image_dest_backup."/".$new_file);
        }
       }
/*
       break;

    case 3: // random filename
        $rand_numb = substr(md5(uniqid(microtime())), 0, 8);
        $file_extension = get_file_extension($image_media_file);
        $file_name = get_file_name($image_media_file);
        while (file_exists($image_dest."/".$rand_numb.".".$file_extension)) {
          $rand_numb = substr(md5(uniqid(microtime())), 0, 8);
        }
        $new_file = $rand_numb.".".$file_extension;
        $ok = copy($image_src."/".$image_media_file, $image_dest."/".$new_file);
        break;
     case 4: // do nothing if exists, highest protection
     default:
       if (file_exists($image_src."/".$image_media_file)) {
         if (file_exists($image_dest."/".$image_media_file)) {
           $ok = 0;
         }
         else {
           $ok = copy($image_src."/".$image_media_file, $image_dest."/".$image_media_file);
         }
       }
       break;
     }
*/
    if (file_exists($image_src_file_big)) {
      if (!@is_dir($image_dest_big)) {
        $oldumask = umask(0);
        $result = @mkdir($image_dest_big);
        umask($oldumask);
        if (!@is_dir($image_dest_big) || !$result) {
          @mkdir($image_dest_big, CHMOD_DIRS);
        }
      }
      if (!file_exists($image_dest_big."/".$new_file)) {
        if (!copy($image_src_file_big, $image_dest_big."/".$new_file)) {
          $error_log[] = str_replace("{src}", $image_src_file_big, str_replace("{des}", $image_dest_big."/".$new_file, $lang['copy_file_error']));
        }
      }
    }
    if (file_exists($image_src_file_backup)) {
      if (!@is_dir($image_dest_backup)) {
        $oldumask = umask(0);
        $result = @mkdir($image_dest_backup);
        umask($oldumask);
        if (!@is_dir($image_dest_backup) || !$result) {
          @mkdir($image_dest_backup, CHMOD_DIRS);
        }
      }
      if (!file_exists($image_dest_backup."/".$new_file)) {
        if (!copy($image_src_file_backup, $image_dest_backup."/".$new_file)) {
          $error_log[] = str_replace("{src}", $image_src_file_backup, str_replace("{des}", $image_dest_backup."/".$new_file, $lang['copy_file_error']));
        }
      }
    }
    if ($ok) {
      @chmod($image_dest."/".$new_file, CHMOD_FILES);
      @chmod($image_dest_big."/".$new_file, CHMOD_FILES);
      @chmod($image_dest_backup."/".$new_file, CHMOD_FILES);
      return $new_file;
    }
    else {
      return false;
    }
  }else{
    if (is_remote($image_thumb_file)) {
      return $image_thumb_file;
    }

    $thumb_src = ($from_cat != -1) ? THUMB_PATH.(($from_cat != 0) ? "/".$from_cat : "") : THUMB_TEMP_PATH;
    $thumb_dest = ($to_cat != -1) ? THUMB_PATH.(($to_cat != 0) ? "/".$to_cat : "") : THUMB_TEMP_PATH;
    $thumb_src_file = $thumb_src."/".$image_thumb_file;

    if ($image_thumb_file != "" && file_exists($thumb_src."/".$image_thumb_file)) {
      $thumb_extension = get_file_extension($image_thumb_file);
      $new_thumb = get_file_name($image_media_file).".".$thumb_extension;

      if (file_exists($thumb_dest."/".$new_thumb)) {
        @unlink($thumb_dest."/".$new_thumb);
      }
      $ok = copy($thumb_src."/".$image_thumb_file, $thumb_dest."/".$new_thumb);
      if ($ok) {
        @chmod($thumb_dest."/".$new_thumb, CHMOD_FILES);
        $image_thumb_file = $new_thumb;
      }
    }
    return $image_thumb_file;
  }
}

function copy_images($image_ids, $cat_id, $date, $move = 0) {
  global $site_db, $lang, $site_sess, $big, $backup;
  if (empty($image_ids)) {
    echo $lang['no_search_results'];
    return false;
  }
  if (!$cat_id) {
    echo $lang['no_category'];
    return false;
  }
  $error_log = array();
  echo "<br />";
  $sql = "SELECT *
          FROM ".IMAGES_TABLE."
          WHERE image_id IN ($image_ids)";
  $image_result = $site_db->query($sql);
  while ($image_row = $site_db->fetch_array($image_result)) {
    $ok = 0;
    $msg = "";
    $ok_media = 0;
    $ok_thumb = 0;
    $image_cat_id = $image_row['cat_id'];
    $image_id = $image_row['image_id'];
    if ($cat_id != $image_cat_id) {
      $ok_media = do_copy($image_row['image_media_file'], "", $image_cat_id, $cat_id);
      $ok_thumb = do_copy($image_row['image_media_file'], $image_row['image_thumb_file'], $image_cat_id, $cat_id, 0);
      $new_media_name = ($ok_media != $image_row['image_media_file']) ? $ok_media : "";
      $new_thumb_name = ($ok_thumb != $image_row['image_thumb_file']) ? $ok_thumb : "";
      if (!$ok_media) {
        $error_log[] = "<b>".$lang['file_copy_error']."</b> ".$image_row['image_name']." (in category ID: ".$image_cat_id.")<br />";
      }
      if (!$ok_thumb) {
        $error_log[] = "<b>".$lang['file_copy_error']."</b> ".$image_row['image_name']." (in category ID: ".$image_cat_id.")<br />";
      }
      if ($ok_media && $ok_thumb) {
        if ($move) {
          $date_sql = ($date) ? "" : ", image_date = ".time();
          $filenames = (($new_media_name) ? ", image_media_file = '".$new_media_name."'" : "").(($new_thumb_name) ? ", image_thumb_file = '".$new_thumb_name."'" : "");
          $sql = "UPDATE ".IMAGES_TABLE." SET cat_id = ".$cat_id.$filenames.$date_sql." WHERE image_id = ".$image_id;
        }else{
          $image_row['cat_id'] = $cat_id;
          unset($image_row['image_id']);
          $keys = array();
          $vals = array();
          foreach ($image_row as $key => $val) {
            if (!intval($key) && $key && $val) {
              if ($key == "image_date" && !$date) {
                $val = time();
              }
              if ($key == "image_media_file" && $new_media_name) {
                $val = $new_media_name;
              }
              if ($key == "image_thumb_file" && $new_thumb_name) {
                $val = $new_thumb_name;
              }
              $keys[] = $key;
              $vals[] = "'".$val."'";
            }
          }
          $sql = "INSERT INTO ".IMAGES_TABLE."
                  (".implode(", ", $keys).")
                  VALUES
                  (".implode(", ", $vals).")";
        }
        if ($site_db->query($sql)) {
          if (!$move) {
            $image_id = $site_db->get_insert_id();
          }
          $msg = "<b>".$lang['copy_success']."</b> <a href=\"".$site_sess->url(ROOT_PATH."details.php?".URL_IMAGE_ID."=".$image_id)."\" target=_blank>".$image_row['image_name']."</a> (from category ID: ".$image_cat_id." to ".$cat_id.")<br />\n";
          $ok = 1;
        } else if (!$move){
          $error_log[] = str_replace("{src}", $image_row['image_name'], str_replace("{from}", $image_cat_id, str_replace("{to}", $cat_id, $lang['copy_file_error'])))."<br />";
        }
      } else if (!$move){
        $error_log[] = str_replace("{src}", $image_row['image_name'], str_replace("{from}", $image_cat_id, str_replace("{to}", $cat_id, $lang['copy_file_error'])))."<br />";
      }
    }else{
      $msg = "<b>".$lang['skiped']."</b> ".$image_row['image_name']." (".$lang['src_des_same'].")<br />\n";
    }
    if ($move && $cat_id != $image_cat_id && $ok) {
      if (!is_remote($image_row['image_media_file']) && !is_local_file($image_row['image_media_file'])) {
        if (@unlink(MEDIA_PATH."/".$image_cat_id."/".$image_row['image_media_file'])) {
          $ok_media = 1;
        }
        else {
          $error_log[] = "<b>".$lang['file_delete_error']."</b> (".$image_row['image_media_file']." ".$lang['in_cat_id'].": ".$image_cat_id.")<br />";
        }
      }
      if ($ok_media && !empty($image_row['image_thumb_file']) && !is_remote($image_row['image_thumb_file']) && !is_local_file($image_row['image_thumb_file'])) {
        if (@unlink(THUMB_PATH."/".$image_cat_id."/".$image_row['image_thumb_file'])) {
          $ok_thumb = 1;
        }
        else {
          $error_log[] = "<b>".$lang['thumb_delete_error']." (".$image_row['image_thumb_file']." in category ID: ".$image_cat_id.")<br />\n";
        }
      }
      if ($big && file_exists(MEDIA_PATH."/".$image_cat_id."/".$big."/".$image_row['image_media_file'])) {
  			if (!@unlink(MEDIA_PATH."/".$image_cat_id."/".$big."/".$image_row['image_media_file'])) {
          $error_log[] = "<b>".$lang['error_del_big']."</b> (".$big."/".$image_row['image_media_file']." ".$lang['in_cat_id'].": ".$image_cat_id.")<br />";
        }
      }
      if ($backup && file_exists($backup."/".$image_cat_id."/".$image_row['image_media_file'])) {
  			if (!unlink($backup."/".$image_cat_id."/".$image_row['image_media_file'])) {
          $error_log[] = "<b>".$lang['error_del_backup']."</b> (".$backup."/".$image_row['image_media_file']." ".$lang['in_cat_id'].": ".$image_cat_id.")<br />";
        }
      }

      if ($ok_thumb) {
        $msg = "<b>".$lang['moved']."</b> <a href=\"".$site_sess->url(ROOT_PATH."details.php?".URL_IMAGE_ID."=".$image_id)."\" target=_blank>".$image_row['image_name']."</a> (".$lang['in_cat_id'].": ".$image_cat_id." to ".$cat_id.")<br />\n";
      }else{
        $error_log[] = "<b>".$lang['move_error']."</b> ".$image_row['image_name']." (".$lang['in_cat_id'].": ".$image_cat_id." to ".$cat_id.")<br />";
      }
    }

    echo $msg."<br />\n";
  }
  return $error_log;
}

show_admin_header();

if ($action == "deleteimage") {
  $selectimages = (isset($HTTP_POST_VARS['selectimages'])) ? $HTTP_POST_VARS['selectimages'] : array();
  $delfromserver = (isset($HTTP_POST_VARS['delfromserver'])) ? intval($HTTP_POST_VARS['delfromserver']) : 1;
  $image_ids = "";
  if (!empty($selectimages)) {
    foreach ($selectimages as $val) {
      $image_ids .= (($image_ids != "") ? ", " : "").$val;
    }
  }
  $lang_key = (count($selectimages) > 1) ? 'images' : 'image';
  show_table_header($lang['delete'].": ".$lang[$lang_key], 1);
  echo "<tr><td class=\"tablerow\">\n";
  echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
  $error_log = delete_images($image_ids, $delfromserver);
  echo "</td></tr></table>\n";
  echo "</td></tr>\n";
  show_table_footer();
  if (!empty($error_log)) {
    show_table_header("Error Log:", 1);
    echo "<tr><td class=\"tablerow\">\n";
    echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
    echo "<b>".$lang['error_log_desc']."</b>\n<ul>\n";
    foreach ($error_log as $val) {
      printf("<li>%s</li>\n", $val);
    }
    echo "</ul>\n</td></tr></table>\n";
    echo "</td></tr>\n";
    show_table_footer();
  }
  echo "<p>";
  show_text_link($lang['back_overview'], "images.php?action=modifyimages");
}

if ($action == "removeimage") {
  $image_ids = array();
  if ((isset($HTTP_GET_VARS['image_id']) && intval($HTTP_GET_VARS['image_id'])) || (isset($HTTP_POST_VARS['image_id']) && intval($HTTP_POST_VARS['image_id']))) {
    $image_id = (isset($HTTP_GET_VARS['image_id'])) ? intval($HTTP_GET_VARS['image_id']) : intval($HTTP_POST_VARS['image_id']);
    $image_ids[] = $image_id;
  }
  elseif (isset($HTTP_POST_VARS['selectimages'])) {
    $image_ids = $HTTP_POST_VARS['selectimages'];
  }
  else {
   $image_ids[] = 0;
  }

  if ($image_ids[0] != 0) {
    show_form_header("images.php", "deleteimage");
    foreach ($image_ids as $val) {
      show_hidden_input("selectimages[]", $val);
    }
    $lang_key = (count($image_ids) > 1) ? 'images' : 'image';
    show_table_header($lang['delete'].": ".$lang[$lang_key], 2);
    show_description_row($lang['delete_image_confirm']);
    show_radio_row($lang['delete_image_files_confirm'], "delfromserver", 1);
    show_form_footer($lang['yes'], "", 2, $lang['no']);
  }else{
    $error_log[] = $lang['no_search_results'];
    $action = "findimages";
  }
}
if ($action == $lang['changeowner'] || $action == "changeowner") {
  $image_ids = array();
  if (isset($HTTP_POST_VARS['selectimages']) && $HTTP_POST_VARS['selectimages']) {
    $image_ids = $HTTP_POST_VARS['selectimages'];
  }
  if ((isset($HTTP_GET_VARS['owner']) && intval($HTTP_GET_VARS['owner'])) || (isset($HTTP_POST_VARS['owner']) && intval($HTTP_POST_VARS['owner'])))
  {
    $owner = (isset($HTTP_GET_VARS['owner'])) ? intval($HTTP_GET_VARS['owner']) : intval($HTTP_POST_VARS['owner']);
  }
  if (!empty($image_ids) && is_array($image_ids))
  {
    if ($owner)
    {
      $sql = "UPDATE ".IMAGES_TABLE."
              SET user_id = ".$owner."
              WHERE image_id IN (".implode(",",$image_ids).")";
      if ($site_db->query($sql))
      {
        $msg = $lang['owner_success'];
      }
      else
      {
        $error_log[] = $lang['owner_error'];
      }
    }
    else
    {
     $error_log[] = $lang['no_user_select'];
    }
  }
  else
  {
    $error_log[] = $lang['no_search_results'];
  }
  $action = "findimages";
}

if ($action == "saveedit") {
  $selectimages = (isset($HTTP_POST_VARS['selectimages'])) ? $HTTP_POST_VARS['selectimages'] : array();
  $image_allow_comments = (isset($HTTP_POST_VARS['image_allow_comments']) && $HTTP_POST_VARS['image_allow_comments']) ? $HTTP_POST_VARS['image_allow_comments'] : 0;
  $image_description = un_htmlspecialchars(trim($HTTP_POST_VARS['image_description']));
  $image_date = (trim($HTTP_POST_VARS['image_date']) != "") ? "UNIX_TIMESTAMP('".trim($HTTP_POST_VARS['image_date'])."')" : 0;
  $image_active = intval($HTTP_POST_VARS['image_active']);

  $image_keywords = trim($HTTP_POST_VARS['image_keywords']);
  $image_keywords = preg_replace("/[\n\r]/is", " ", $image_keywords);
  $image_keywords = str_replace(","," ",$image_keywords);
  $image_keywords = ereg_replace("( ){2,}", " ", $image_keywords);

  $image_ids = implode(",",$selectimages);
  $lang_key = (count($selectimages) > 1) ? 'images' : 'image';
  $lang_key2 = (count($selectimages) > 1) ? 'Images' : 'Image';
  show_table_header("Edit ".$lang_key, 2);
  echo "<tr><td class=\"tablerow\">\n";
  echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
  $date = ($image_date) ? ", image_date = ".$image_date : "";
  $sql = "UPDATE ".IMAGES_TABLE."
          SET image_description = '$image_description', image_keywords = '$image_keywords', image_allow_comments = $image_allow_comments, image_active = $image_active.$date
          WHERE image_id IN ($image_ids)";
  $result = $site_db->query($sql);
  if ($result) {
    $sql = "SELECT image_id, cat_id, image_name, image_keywords, image_description, image_media_file
            FROM ".IMAGES_TABLE."
            WHERE image_id IN (".implode(",", $selectimages).")";
    $result = $site_db->query($sql);
    $list = "";
    while ($row = $site_db->fetch_array($result)) {
      $image_row[$row['image_id']] = $row;
    }
    remove_searchwords($image_ids);
    foreach ($image_row as $key => $val) {
      $search_words = array();
      foreach ($search_match_fields as $image_column => $match_column) {
        $search_words[$image_column] = stripslashes($val[$image_column]);
      }
      add_searchwords($key, $search_words);
    }
    echo "<b>$lang_key2 updated successfuly</b>\n</td></tr></table>\n";
    echo "</td></tr>\n";
    echo "</td></tr></table>\n";
    echo "</td></tr>\n";
    show_table_footer();
  }
  else{
    echo "</td></tr></table>\n";
    echo "</td></tr>\n";
    show_table_footer();
    show_table_header("Error Log:", 1);
    echo "<tr><td class=\"tablerow\">\n";
    echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
    echo "<b>Error updating $lang_key</b>\n</td></tr></table>\n";
    echo "</td></tr>\n";
    show_table_footer();
  }
  echo "<p>";
  show_text_link($lang['back_overview'], "images.php?action=modifyimages");
}

if ($action == $lang['edit'] || $action == "edit") {
  $image_ids = array();
  if ((isset($HTTP_GET_VARS['image_id']) && intval($HTTP_GET_VARS['image_id'])) || (isset($HTTP_POST_VARS['image_id']) && intval($HTTP_POST_VARS['image_id']))) {
    $image_id = (isset($HTTP_GET_VARS['image_id'])) ? intval($HTTP_GET_VARS['image_id']) : intval($HTTP_POST_VARS['image_id']);
    $image_ids[] = $image_id;
  }
  elseif (isset($HTTP_POST_VARS['selectimages'])) {
    $image_ids = $HTTP_POST_VARS['selectimages'];
  }
  else {
   $image_ids[] = 0;
  }

  if ($image_ids[0] != 0) {
    show_form_header("images.php", "saveedit");
    foreach ($image_ids as $val) {
      show_hidden_input("selectimages[]", $val);
    }
    $sql = "SELECT image_id, image_name, image_keywords, image_description, image_allow_comments, image_active, FROM_UNIXTIME(image_date) AS image_date, image_media_file, image_thumb_file
            FROM ".IMAGES_TABLE."
            WHERE image_id IN (".implode(",", $image_ids).")";
    $result = $site_db->query($sql);
    $list = "";
    while ($row = $site_db->fetch_array($result)) {
      $image_row[$row['image_id']] = $row;
      $list .= (($row['image_name']) ? "<a href=\"../details.php?image_id=".$row['image_id']."\" target=\"_blank\">".$row['image_name']."</a>" : "<b class=\"marktext\">".$lang['lang_error']."</b>")." (ID: ".$row['image_id']."), ";
    }
    show_table_header("Edit ".((count($image_ids) > 1) ? 'images' : 'image'), 2);
    show_custom_row($lang['images_update'], trim($list, ", "));
    $file_src = get_file_path($image_row[$image_ids[0]]['image_media_file'], "media", $image_row[$image_ids[0]]['cat_id'], 1);
    $title = $lang['field_description_ext'].((isset($file_src)) ? get_iptc_insert_link($file_src, "caption", "image_description") : "");
    show_textarea_row($title, "image_description", $image_row[$image_ids[0]]['image_description'], $textarea_size);
  
    $title = $lang['field_keywords_ext'].((isset($file_src)) ? get_iptc_insert_link($file_src, "keyword", "image_keywords") : "");
    show_textarea_row($title, "image_keywords", $image_row[$image_ids[0]]['image_keywords'], $textarea_size);
    $title = $lang['field_date'].$lang['date_desc'].$lang['date_format'];
    show_input_row($title, "image_date", $image_row[$image_ids[0]]['image_date'], $textinput_size);
    show_radio_row($lang['field_free'], "image_active", $image_row[$image_ids[0]]['image_active']);
    show_radio_row($lang['field_allow_comments'], "image_allow_comments", $image_row[$image_ids[0]]['image_allow_comments']);
    show_form_footer($lang['save_changes'], $lang['reset'], 2, "", " onClick='showProgress()'");
  }else{
    $error_log[] = $lang['no_search_results'];
    $action = "findimages";
  }
}

if ($action == "docopy") {
  $selectimages = (isset($HTTP_POST_VARS['selectimages'])) ? $HTTP_POST_VARS['selectimages'] : array();
  $cat_id = (isset($HTTP_POST_VARS['new_cat_id'])) ? $HTTP_POST_VARS['new_cat_id'] : 0;
  $date = (isset($HTTP_POST_VARS['date']) && intval($HTTP_POST_VARS['date'])) ? 1 : 0;
  $image_ids = "";
  if (!empty($selectimages)) {
    foreach ($selectimages as $val) {
      $image_ids .= (($image_ids != "") ? ", " : "").$val;
    }
  }
  $lang_key = (count($selectimages) > 1) ? 'images' : 'image';
  show_table_header("Copy: ".$lang[$lang_key], 1);
  echo "<tr><td class=\"tablerow\">\n";
  echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
  $error_log = copy_images($image_ids, $cat_id, $date);
  echo "</td></tr></table>\n";
  echo "</td></tr>\n";
  show_table_footer();
  if (!empty($error_log)) {
    show_table_header("Error Log:", 1);
    echo "<tr><td class=\"tablerow\">\n";
    echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
    echo "<b>".$lang['error_log_desc']."</b>\n<ul>\n";
    foreach ($error_log as $val) {
      printf("<li>%s</li>\n", $val);
    }
    echo "</ul>\n</td></tr></table>\n";
    echo "</td></tr>\n";
    show_table_footer();
  }
  echo "<p>";
  show_text_link($lang['back_overview'], "images.php?action=modifyimages");
}

if ($action == $lang['copy'] || $action == "copy") {
  $image_ids = array();
  if (isset($HTTP_POST_VARS['selectimages'])) {
    $image_ids = $HTTP_POST_VARS['selectimages'];
  }
  else {
   $image_ids[] = 0;
  }
  $cat_id = (isset($HTTP_POST_VARS['new_cat_id'])) ? $HTTP_POST_VARS['new_cat_id'] : 0;
  $date = (isset($HTTP_POST_VARS['date']) && intval($HTTP_POST_VARS['date'])) ? 1 : 0;
  if ($image_ids[0] != 0 && $cat_id) {
    show_form_header("images.php", "docopy");
    foreach ($image_ids as $val) {
      show_hidden_input("selectimages[]", $val);
    }
    show_hidden_input("new_cat_id", $cat_id);
    show_hidden_input("date", $date);
    $lang_key = (count($image_ids) > 1) ? 'images' : 'image';
    show_table_header("Copy: ".$lang[$lang_key], 2);
    show_description_row("Copy image files to category ID: ".$cat_id."?");
    show_form_footer($lang['yes'], "", 2, $lang['no']);
  }else{
    if ($image_ids[0] == 0) {
      $error_log[] = $lang['no_search_results'];
    }
    if (!$cat_id) {
      $error_log[] = $lang['no_category'];
    }
    $action = "findimages";
  }
}

if ($action == "domove") {
  $selectimages = (isset($HTTP_POST_VARS['selectimages'])) ? $HTTP_POST_VARS['selectimages'] : array();
  $cat_id = (isset($HTTP_POST_VARS['new_cat_id'])) ? $HTTP_POST_VARS['new_cat_id'] : 0;
  $date = (isset($HTTP_POST_VARS['date']) && intval($HTTP_POST_VARS['date'])) ? 1 : 0;
  $image_ids = "";
  if (!empty($selectimages)) {
    foreach ($selectimages as $val) {
      $image_ids .= (($image_ids != "") ? ", " : "").$val;
    }
  }
  $lang_key = (count($selectimages) > 1) ? 'images' : 'image';
  show_table_header("Move: ".$lang[$lang_key], 1);
  echo "<tr><td class=\"tablerow\">\n";
  echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
  $error_log = copy_images($image_ids, $cat_id, $date, 1);
  echo "</td></tr></table>\n";
  echo "</td></tr>\n";
  show_table_footer();
  if (!empty($error_log)) {
    show_table_header("Error Log:", 1);
    echo "<tr><td class=\"tablerow\">\n";
    echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
    echo "<b>".$lang['error_log_desc']."</b>\n<ul>\n";
    foreach ($error_log as $val) {
      printf("<li>%s</li>\n", $val);
    }
    echo "</ul>\n</td></tr></table>\n";
    echo "</td></tr>\n";
    show_table_footer();
  }
  echo "<p>";
  show_text_link($lang['back_overview'], "images.php?action=modifyimages");
}

if ($action == $lang['move'] || $action == "move") {
  $image_ids = array();
  if (isset($HTTP_POST_VARS['selectimages'])) {
    $image_ids = $HTTP_POST_VARS['selectimages'];
  }
  else {
   $image_ids[] = 0;
  }
  $cat_id = (isset($HTTP_POST_VARS['new_cat_id'])) ? $HTTP_POST_VARS['new_cat_id'] : 0;
  $date = (isset($HTTP_POST_VARS['date']) && intval($HTTP_POST_VARS['date'])) ? 1 : 0;
  if ($image_ids[0] != 0 && $cat_id) {
    show_form_header("images.php", "domove");
    foreach ($image_ids as $val) {
      show_hidden_input("selectimages[]", $val);
    }
    show_hidden_input("date", $date);
    show_hidden_input("new_cat_id", $cat_id);
    $lang_key = (count($image_ids) > 1) ? 'images' : 'image';
    show_table_header("Move: ".$lang[$lang_key], 2);
    show_description_row("Move image files to category ID: ".$cat_id."?");
    show_form_footer($lang['yes'], "", 2, $lang['no']);
  }else{
    if ($image_ids[0] == 0) {
      $error_log[] = $lang['no_search_results'];
    }
    if (!$cat_id) {
      $error_log[] = $lang['no_category'];
    }
    $action = "findimages";
  }
}

if ($action == "updateimage") {
  $error_msg = "";
  $error = array();

  $image_id = (isset($HTTP_POST_VARS['image_id'])) ? intval($HTTP_POST_VARS['image_id']) : intval($HTTP_GET_VARS['image_id']);
  $image_name = trim($HTTP_POST_VARS['image_name']);
  $image_description = un_htmlspecialchars(trim($HTTP_POST_VARS['image_description']));

  $image_keywords = trim($HTTP_POST_VARS['image_keywords']);
  $image_keywords = preg_replace("/[\n\r]/is", " ", $image_keywords);
  $image_keywords = str_replace(","," ",$image_keywords);
  $image_keywords = ereg_replace("( ){2,}", " ", $image_keywords);

  $cat_id = intval($HTTP_POST_VARS['cat_id']);
  $old_cat_id = intval($HTTP_POST_VARS['old_cat_id']);

  $user_id = (intval($HTTP_POST_VARS['user_id']) != 0) ? intval($HTTP_POST_VARS['user_id']) : $user_info['user_id'];

  $image_date = (trim($HTTP_POST_VARS['image_date']) != "") ? "UNIX_TIMESTAMP('".trim($HTTP_POST_VARS['image_date'])."')" : time();
  $image_active = intval($HTTP_POST_VARS['image_active']);
  $image_allow_comments = intval($HTTP_POST_VARS['image_allow_comments']);
  $image_downloads = (trim($HTTP_POST_VARS['image_downloads']) != "") ? intval($HTTP_POST_VARS['image_downloads']) : 0;
  $image_votes = (trim($HTTP_POST_VARS['image_votes']) != "") ? intval($HTTP_POST_VARS['image_votes']) : 0;
  $image_rating = (trim($HTTP_POST_VARS['image_rating']) != "") ? sprintf("%.2f", trim($HTTP_POST_VARS['image_rating'])) : "0.00";
  $image_hits = (trim($HTTP_POST_VARS['image_hits']) != "") ? intval(trim($HTTP_POST_VARS['image_hits'])) : 0;

  $remote_file = trim($HTTP_POST_VARS['remote_file']);
  $remote_thumb_file = trim($HTTP_POST_VARS['remote_thumb_file']);

  $old_file_name = trim($HTTP_POST_VARS['old_file_name']);
  $old_thumb_file_name = trim($HTTP_POST_VARS['old_thumb_file_name']);

  $image_download_url = trim($HTTP_POST_VARS['image_download_url']);
  $delete_thumb_file = (isset($HTTP_POST_VARS['delete_thumb_file']) && $HTTP_POST_VARS['delete_thumb_file'] == 1) ? 1 : 0;

  if ($image_name == "") {
    $error['image_name'] = 1;
  }
  if ($cat_id == 0) {
    $error['cat_id'] = 1;
  }
  if ($image_download_url != "" && !is_remote($image_download_url) && !is_local_file($image_download_url)) {
    $error['image_download_url'] = 1;
  }

  if ((empty($HTTP_POST_FILES['file']['tmp_name']) || $HTTP_POST_FILES['file']['tmp_name'] == "none") && $remote_file != "" && !check_remote_media($remote_file) && !check_local_media($remote_file)) {
    $error['remote_file'] = 1;
  }
  if ((empty($HTTP_POST_FILES['thumb_file']['tmp_name']) || $HTTP_POST_FILES['thumb_file']['tmp_name'] == "none") && $remote_thumb_file != "" && !check_remote_thumb($remote_thumb_file) && !check_local_thumb($remote_thumb_file)) {
    $error['remote_thumb_file'] = 1;
  }

  if (!empty($additional_image_fields)) {
    foreach ($additional_image_fields as $key => $val) {
      if (isset($HTTP_POST_VARS[$key]) && intval($val[2]) == 1 && trim($HTTP_POST_VARS[$key]) == "") {
        $error[$key] = 1;
      }
    }
  }

  if (!empty($HTTP_POST_FILES['file']['tmp_name']) && $HTTP_POST_FILES['file']['tmp_name'] != "none" && !$error) {
    unset($HTTP_POST_VARS['remote_file']);
    @rename(MEDIA_PATH."/".$old_cat_id."/".$old_file_name, MEDIA_PATH."/".$old_cat_id."/".$old_file_name.".bak");
    if ($big)
    {
      @rename(MEDIA_PATH."/".$old_cat_id."/".$big."/".$old_file_name, MEDIA_PATH."/".$old_cat_id."/".$big."/".$old_file_name.".bak");
    }
    if (BACKUPDIR)
    {
      @rename(BACKUPDIR."/".$old_cat_id."/".$old_file_name, BACKUPDIR."/".$old_cat_id."/".$old_file_name.".bak");
    }
    $new_name = $site_upload->upload_file("file", "media", $cat_id);
    if (!$new_name) {
      $error_msg .= $lang['file_upload_error'].": <b>".$HTTP_POST_FILES['file']['name']."</b><br />".$site_upload->get_upload_errors();
      @rename(MEDIA_PATH."/".$old_cat_id."/".$old_file_name.".bak", MEDIA_PATH."/".$old_cat_id."/".$old_file_name);
      if ($big)
      {
        @rename(MEDIA_PATH."/".$old_cat_id."/".$big."/".$old_file_name.".bak", MEDIA_PATH."/".$old_cat_id."/".$big."/".$old_file_name);
      }
      if (BACKUPDIR)
      {
        @rename(BACKUPDIR."/".$old_cat_id."/".$old_file_name.".bak", BACKUPDIR."/".$old_cat_id."/".$old_file_name);
      }
      $error = 1;
    }
    else {
      unlink(MEDIA_PATH."/".$old_cat_id."/".$old_file_name.".bak");
      @unlink(MEDIA_PATH."/".$old_cat_id."/".$big."/".$old_file_name.".bak");
      @unlink(BACKUPDIR."/".$old_cat_id."/".$old_file_name.".bak");
      $log[] = $lang['file_upload_success'].": <b>$new_name</b>";
    }
  }
  elseif ((empty($HTTP_POST_FILES['file']['tmp_name']) || $HTTP_POST_FILES['file']['tmp_name'] == "none") && $remote_file != "" && (check_remote_media($remote_file) || check_local_media($remote_file))) {
    $new_name = $remote_file;
    if (file_exists(MEDIA_PATH."/".$old_cat_id."/".$old_file_name) && is_file(MEDIA_PATH."/".$old_cat_id."/".$old_file_name)) {
      unlink(MEDIA_PATH."/".$old_cat_id."/".$old_file_name);
      @unlink(MEDIA_PATH."/".$old_cat_id."/".$big."/".$old_file_name);
      @unlink(BACKUPDIR."/".$old_cat_id."/".$old_file_name);
    }
  }
  else {
    if ($cat_id != $old_cat_id && !empty($old_file_name)) {
      $new_name = copy_media($old_file_name, $old_cat_id, $cat_id, $big, $backup);
    }
    else {
      $new_name = $old_file_name;
    }
  }

  if ($delete_thumb_file == 1) {
    if (!empty($old_thumb_file_name) && file_exists(THUMB_PATH."/".$old_cat_id."/".$old_thumb_file_name)) {
      unlink(THUMB_PATH."/".$old_cat_id."/".$old_thumb_file_name);
    }
    $new_thumb_name = "";
    unset($HTTP_POST_VARS['remote_thumb_file']);
  }
  elseif (!empty($HTTP_POST_FILES['thumb_file']['tmp_name']) && $HTTP_POST_FILES['thumb_file']['tmp_name'] != "none" && !$error) {
    unset($HTTP_POST_VARS['remote_thumb_file']);
    @rename(THUMB_PATH."/".$old_cat_id."/".$old_thumb_file_name, THUMB_PATH."/".$old_cat_id."/".$old_thumb_file_name.".bak");
    $new_thumb_name = $site_upload->upload_file("thumb_file", "thumb", $cat_id, basename($new_name));
    if (!$new_thumb_name) {
      $error_msg .= $lang['thumb_upload_error'].": <b>".$HTTP_POST_FILES['thumb_file']['name']."</b><br />".$site_upload->get_upload_errors();
      @rename(THUMB_PATH."/".$old_cat_id."/".$old_thumb_file_name.".bak", THUMB_PATH."/".$old_cat_id."/".$old_thumb_file_name);
      @unlink(MEDIA_PATH."/".$old_cat_id."/".$new_name);
      $error = 1;
    }
    else {
      $log[] = $lang['thumb_upload_success'].": <b>$new_thumb_name</b>";
    }
  }
  elseif ((empty($HTTP_POST_FILES['thumb_file']['tmp_name']) || $HTTP_POST_FILES['thumb_file']['tmp_name'] == "none") && $remote_thumb_file != "" && (check_remote_thumb($remote_thumb_file) || check_local_thumb($remote_thumb_file))) {
    $new_thumb_name = $remote_thumb_file;
    if (file_exists(THUMB_PATH."/".$old_cat_id."/".$old_thumb_file_name) && is_file(THUMB_PATH."/".$old_cat_id."/".$old_thumb_file_name)) {
      unlink(THUMB_PATH."/".$old_cat_id."/".$old_thumb_file_name);
    }
  }
  else {
    if ($cat_id != $old_cat_id && !empty($old_thumb_file_name)) {
      $new_thumb_name = copy_thumbnail($new_name, $old_thumb_file_name, $old_cat_id, $cat_id);
    }
    else {
      $new_thumb_name = $old_thumb_file_name;
    }
  }

  if (empty($error)) {
    $additional_sql = "";
    if (!empty($additional_image_fields)) {
      $table_fields = $site_db->get_table_fields(IMAGES_TABLE);
      foreach ($additional_image_fields as $key => $val) {
        if (isset($HTTP_POST_VARS[$key]) && isset($table_fields[$key])) {
          $additional_sql .= ", $key = '".un_htmlspecialchars(trim($HTTP_POST_VARS[$key]))."'";
        }
      }
    }

    $sql = "UPDATE ".IMAGES_TABLE."
            SET cat_id = $cat_id, user_id = $user_id, image_name = '$image_name', image_description = '$image_description', image_keywords = '$image_keywords', image_date = $image_date, image_active = $image_active, image_media_file = '$new_name', image_thumb_file = '$new_thumb_name', image_download_url = '$image_download_url', image_allow_comments = $image_allow_comments, image_downloads = $image_downloads, image_votes = $image_votes, image_rating = '$image_rating', image_hits = $image_hits".$additional_sql."
            WHERE image_id = $image_id";
    $result = $site_db->query($sql);

    if (isset($HTTP_POST_VARS['cat_image']))
    {
      $sql = "UPDATE ".CATEGORIES_TABLE."
              SET cat_image = ".((intval($HTTP_POST_VARS['cat_image'])) ? intval($HTTP_POST_VARS['cat_image']) : ((isset($HTTP_POST_VARS['cat_image_old']) && $HTTP_POST_VARS['cat_image_old'] != $image_id) ? $HTTP_POST_VARS['cat_image_old'] : 0))."
              WHERE cat_id = $cat_id";
      $result = $site_db->query($sql);
    }
    @unlink(MEDIA_PATH."/".$old_cat_id."/".$old_file_name.".bak");
    @unlink(MEDIA_PATH."/".$old_cat_id."/".$big."/".$old_file_name.".bak");
    @unlink($backup."/".$old_cat_id."/".$old_file_name.".bak");
    @unlink(THUMB_PATH."/".$old_cat_id."/".$old_thumb_file_name.".bak");
    update_comment_count($image_id);

    if ($result) {
      $search_words = array();
      foreach ($search_match_fields as $image_column => $match_column) {
        if (isset($HTTP_POST_VARS[$image_column])) {
          $search_words[$image_column] = stripslashes($HTTP_POST_VARS[$image_column]);
        }
      }
      remove_searchwords($image_id);
      add_searchwords($image_id, $search_words);
      $msg = $lang['image_edit_success'];
      $msg_color = 1;
    }
    else {
      $msg = $lang['image_edit_error'];
    }
  }
  else {
    $msg = sprintf("<span class=\"marktext\">%s</span>", $lang['lostfield_error']);
    $msg .= $error_msg;
  }
  echo "<script language=javascript>\n showProgress();\n hideProgress();\n</script>";
  $action = "editimage";
}
if ($action == $lang['save'] || $action == "save") {
  $editname = isset($HTTP_POST_VARS['editname']) ? intval(trim($HTTP_POST_VARS['editname'])) : 0;
  $editdescription = isset($HTTP_POST_VARS['editdescription']) ? intval(trim($HTTP_POST_VARS['editdescription'])) : 0;
  $editkeywords = isset($HTTP_POST_VARS['editkeywords']) ? intval(trim($HTTP_POST_VARS['editkeywords'])) : 0;
  $editdate = isset($HTTP_POST_VARS['editdate']) ? intval(trim($HTTP_POST_VARS['editdate'])) : 0;
  $image_ids = array();
  $image_name = array();
  $image_description = array();
  $image_keywords = array();
  if (isset($HTTP_POST_VARS['selectimages'])) {
    $image_ids = $HTTP_POST_VARS['selectimages'];
  }
  else {
    $image_ids[] = 0;
  }
  if (isset($HTTP_POST_VARS['name'])) {
    $image_name = $HTTP_POST_VARS['name'];
  }
  else {
    $image_name[] = 0;
  }
  if (isset($HTTP_POST_VARS['description'])) {
    $image_description = $HTTP_POST_VARS['description'];
  }
  else {
    $image_description[] = 0;
  }
  if (isset($HTTP_POST_VARS['keywords'])) {
    $image_keywords = $HTTP_POST_VARS['keywords'];
  }
  else {
   $image_keywords[] = 0;
  }
  if (isset($HTTP_POST_VARS['image_date'])) {
    $image_date = $HTTP_POST_VARS['image_date'];
  }
  else {
   $image_date[] = 0;
  }
  foreach ($image_ids as $key => $val) {
    $image_keywords[$key] = preg_replace("/[\n\r]/is", " ", $image_keywords[$key]);
    $image_keywords[$key] = str_replace(","," ",$image_keywords[$key]);
    $image_keywords[$key] = ereg_replace("( ){2,}", " ", $image_keywords[$key]);
    $set = (($editname && !empty($image_name[$key])) ? " image_name = '".trim(addslashes($image_name[$key]))."'" : "").(($editdescription) ? ", image_description = '".trim(addslashes($image_description[$key]))."'" : "").(($editkeywords) ? ", image_keywords = '".trim(addslashes($image_keywords[$key]))."'" : "").(($editdate) ? ", image_date = UNIX_TIMESTAMP('".$image_date[$key]."')" : "");
    $sql = "UPDATE ".IMAGES_TABLE."
            SET".trim($set, ",")."
            WHERE image_id = $val";
//echo $sql."<br>";
    $result = $site_db->query($sql);
    if ($editkeywords) {
      $search_words = array();
      foreach ($search_match_fields as $image_column => $match_column) {
        $image_col = $$image_column;
        if (isset($image_col[$key])) {
          $search_words[$image_column] = stripslashes($image_col[$key]);
        }
      }
      add_searchwords($val, $search_words);
    }
  }
  $msg = "Images successfuly updated";  
  $action = "findimages";
  show_table_header("Save Log:");
  echo "<tr><td class=\"tablerow\">\n";
  echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
  echo "<b>Images successfuly updated</b>\n</td></tr></table>\n";
  echo "</td></tr>\n";
  show_table_footer();
}
if ($action == "editimage") {
  if ($msg != "") {
    printf("<b>%s</b>\n", $msg);
  }
  printf("<p>%s</p>\n", $lang['upload_note']);

  $image_id = (isset($HTTP_POST_VARS['image_id'])) ? intval($HTTP_POST_VARS['image_id']) : intval($HTTP_GET_VARS['image_id']);
  $cat_image = array_keys($cat_cache);
  if ($cat_image = isset($cat_cache[$cat_image[0]]['cat_image']))
  {
    $sql = "SELECT i.*, FROM_UNIXTIME(i.image_date) AS image_date, c.cat_image, b.image_name as cat_image_name, b.image_media_file as cat_image_media_file, b.image_thumb_file as cat_image_thumb_file
            FROM ".IMAGES_TABLE." i
            LEFT JOIN ".CATEGORIES_TABLE." c ON (c.cat_id = i.cat_id)
            LEFT JOIN ".IMAGES_TABLE." b ON (b.image_id = c.cat_image)
            WHERE i.image_id = $image_id";
  }
  else
  {
    $sql = "SELECT *, FROM_UNIXTIME(image_date) AS image_date
            FROM ".IMAGES_TABLE."
            WHERE image_id = $image_id";
  }
  $image_row = $site_db->query_firstrow($sql);

  show_form_header("images.php", "updateimage", "form", 1);
  show_hidden_input("image_id", $image_id);
  show_hidden_input("old_file_name", $image_row['image_media_file']);
  show_hidden_input("old_thumb_file_name", $image_row['image_thumb_file']);
  show_hidden_input("old_cat_id", $image_row['cat_id']);
  show_table_header($lang['nav_images_edit'].": ".$image_row['image_name']." (ID: ".$image_row['image_id'].")", 2);

  $file_src = get_file_path($image_row['image_media_file'], "media", $image_row['cat_id'], 1);
  $dim = 600;
  $height = $dim;
  $width = $dim;
  $file_size = get_resize2($file_src, $dim);
  $width = $file_size[0];
  $height = $file_size[1];
  show_image_row($lang['image']."<br /><span class=\"smalltext\">(".$image_row['image_media_file'].")<br />".$file_size[2][0]."x".$file_size[2][1]."</span>", $file_src, 1, "", $height, $width);

  $value = (is_remote($image_row['image_media_file']) || is_local_file($image_row['image_media_file'])) ? $image_row['image_media_file'] : "";
  show_upload_row($lang['image_file'], "file", "<br /><span class=\"smalltext\">".$lang['allowed_mediatypes_desc'].str_replace(",",", ",$config['allowed_mediatypes'])."</span>", $value);

  if (!empty($image_row['image_thumb_file'])) {
    $thumb_src = get_file_path($image_row['image_thumb_file'], "thumb", $image_row['cat_id'], 1);
    show_image_row($lang['thumb']."<br /><span class=\"smalltext\">(".$image_row['image_thumb_file'].")</span>", $thumb_src, 1, "delete_thumb_file");
  }
  else {
    $file_type = get_file_extension($image_row['image_media_file']);
    show_image_row($lang['thumb']."<br /><span class=smalltext>(".$lang['no_thumb_found'].")</span>", ICON_PATH."/".$file_type.".gif", 1);
  }

  $value = (is_remote($image_row['image_thumb_file']) || is_local_file($image_row['image_thumb_file'])) ? $image_row['image_thumb_file'] : "";
  show_upload_row($lang['thumb_file'], "thumb_file", "<br /><span class=\"smalltext\">".$lang['allowed_mediatypes_desc']." jpg, gif, png</span>", $value);

  show_input_row($lang['field_download_url'].$lang['download_url_desc'], "image_download_url", $image_row['image_download_url'], $textinput_size);

  $title = $lang['field_image_name'].((isset($file_src)) ? get_iptc_insert_link($file_src, "object_name", "image_name", 0) : "");
  show_input_row($title, "image_name", $image_row['image_name'], $textinput_size);

  $title = $lang['field_description_ext'].((isset($file_src)) ? get_iptc_insert_link($file_src, "caption", "image_description") : "");
  show_textarea_row($title, "image_description", $image_row['image_description'], $textarea_size);

  $title = $lang['field_keywords_ext'].((isset($file_src)) ? get_iptc_insert_link($file_src, "keyword", "image_keywords") : "");
  show_textarea_row($title, "image_keywords", $image_row['image_keywords'], $textarea_size);

  show_cat_select_row($lang['field_category'], $image_row['cat_id'], 3);
  show_user_select_row($lang['user'], $image_row['user_id']);

  $title = $lang['field_date'].$lang['date_desc'].$lang['date_format'].((isset($file_src)) ? get_iptc_insert_link($file_src, "date_created", "image_date", 0) : "");
  show_input_row($title, "image_date", $image_row['image_date'], $textinput_size);

  show_radio_row($lang['field_free'], "image_active", $image_row['image_active']);
  show_radio_row($lang['field_allow_comments'], "image_allow_comments", $image_row['image_allow_comments']);
  show_input_row($lang['field_downloads'], "image_downloads", $image_row['image_downloads'], 10);
  show_input_row($lang['field_votes'], "image_votes", $image_row['image_votes'], 10);
  show_input_row($lang['field_rating'], "image_rating", $image_row['image_rating'], 10);
  show_input_row($lang['field_hits'], "image_hits", $image_row['image_hits'], 10);
  show_additional_fields("image", $image_row, IMAGES_TABLE);
  if (isset($image_row['cat_image']))
  {
    $value = ($image_row['cat_image'] && $image_row['image_id'] == $image_row['cat_image']) ? 1 : 0;
    if (isset($HTTP_POST_VARS['cat_image'])) {
      $value = $HTTP_POST_VARS['cat_image'];
    }
    echo "<tr class=\"".get_row_bg()."\">\n";
    echo "<td><p class=\"rowtitle\">Category image";
    if ($image_row['cat_image'])
    {
      if (!get_file_path($image_row['cat_image_thumb_file'], "thumb", $image_row['cat_id'], 0, 0))
      {
        $cat_image = ICON_PATH."/".get_file_extension($image_row['cat_image_media_file']).".gif";
      }
      else
      {
        $cat_image = get_file_path($image_row['cat_image_thumb_file'], "thumb", $image_row['cat_id'], 0, 1);
      }
      $wh = get_resize2($cat_image, 50);
      echo "<br /><span class=\"smalltext\">Current image:<br /><a href=\"".$site_sess->url(ROOT_PATH."details.php?image_id=".$result['cat_image'])."\" target=\"_blank\"><img src=\"".$cat_image."\" width=\"".$wh[0]."\" height=\"".$wh[1]."\" align=\"middle\"></a>&nbsp;<a href=\"".$site_sess->url(ROOT_PATH."details.php?image_id=".$result['cat_image'])."\" target=\"_blank\">".$image_row['cat_image_name']."</a></span>";
    }
    echo "</p></td>\n<td><p>";
    echo "<input type=\"radio\" name=\"cat_image\" value=\"".$image_row['image_id']."\"";
    if ($value) {
      echo " checked=\"checked\"";
    }
    echo "> ".$lang['yes']."&nbsp;&nbsp;&nbsp;\n";
    echo "<input type=\"radio\" name=\"cat_image\" value=\"0\"";
    if (!$value) {
      echo " checked=\"checked\"";
    }
    echo "> ".$lang['no']." ";
    echo "</p></td>\n</tr>";
    show_hidden_input("cat_image_old", $image_row['cat_image']);
  }
  show_form_footer($lang['save_changes'], $lang['reset'], 2, "", " onClick='showProgress()'");
}

if ($action == "saveimages") {
  $error_msg = "";
  $num_newimages = $HTTP_POST_VARS['num_newimages'];

  $error = array();
  for ($i = 1; $i <= $num_newimages; $i++) {
    $image_name = trim($HTTP_POST_VARS['image_name_'.$i]);
    $cat_id = intval($HTTP_POST_VARS['cat_id_'.$i]);
    $user_id = (intval($HTTP_POST_VARS['user_id_'.$i]) != 0) ? intval($HTTP_POST_VARS['user_id_'.$i]) : $user_info['user_id'];
    $remote_file = trim($HTTP_POST_VARS['remote_file_'.$i]);
    $remote_thumb_file = trim($HTTP_POST_VARS['remote_thumb_file_'.$i]);
    $image_download_url = trim($HTTP_POST_VARS['image_download_url_'.$i]);

    if ($image_name == "") {
      $error['image_name_'.$i] = 1;
    }
    if ($cat_id == 0) {
      $error['cat_id_'.$i] = 1;
    }
    if (((empty($HTTP_POST_FILES['file_'.$i]['tmp_name']) || $HTTP_POST_FILES['file_'.$i]['tmp_name'] == "none") && $remote_file == "") || ($remote_file != "" && !check_remote_media($remote_file) && !check_local_media($remote_file))) {
      $error['file_'.$i] = 1;
    }
    if ($remote_thumb_file != "" && !check_remote_thumb($remote_thumb_file) && !check_local_thumb($remote_thumb_file)) {
      $error['remote_thumb_file_'.$i] = 1;
    }
    if ($image_download_url != "" && !is_remote($image_download_url) && !is_local_file($image_download_url)) {
      $error['image_download_url_'.$i] = 1;
    }

    if (!empty($additional_image_fields)) {
      foreach ($additional_image_fields as $key => $val) {
        if (isset($HTTP_POST_VARS[$key.'_'.$i]) && intval($val[2]) == 1 && trim($HTTP_POST_VARS[$key.'_'.$i]) == "") {
          $error[$key.'_'.$i] = 1;
        }
      }
    }
  }

  if (empty($error)) {
    for ($i = 1; $i <= $num_newimages; $i++) {
      $log = array();
      $uploaderror = 0;
      $image_name = trim($HTTP_POST_VARS['image_name_'.$i]);
      $cat_id = intval($HTTP_POST_VARS['cat_id_'.$i]);
      $remote_file = trim($HTTP_POST_VARS['remote_file_'.$i]);
      $remote_thumb_file = trim($HTTP_POST_VARS['remote_thumb_file_'.$i]);

      //Upload Image
      $file = "file_".$i;
      $remote_file = trim($HTTP_POST_VARS['remote_file_'.$i]);
      if (!empty($HTTP_POST_FILES[$file]['tmp_name']) && $HTTP_POST_FILES[$file]['tmp_name'] != "none") {
        $new_name = $site_upload->upload_file($file, "media", $cat_id);
        if (!$new_name) {
          $log[] = "<b>".$lang['file_upload_error'].": ".$HTTP_POST_FILES[$file]['name']."</b><br />".$site_upload->get_upload_errors();
          $uploaderror = 1;
        }
        else {
          $log[] = "<b>".$lang['file_upload_success'].": ".$new_name."</b>";
        }
      }
      else {
        $new_name = $remote_file;
      }

      //Upload Thumbnail if exists
      $thumb_file = "thumb_file_".$i;
      $remote_thumb_file = trim($HTTP_POST_VARS['remote_thumb_file_'.$i]);
      $new_thumb_name = "";
      if (!empty($HTTP_POST_FILES[$thumb_file]['tmp_name']) && $HTTP_POST_FILES[$thumb_file]['tmp_name'] != "none" && !$uploaderror) {
        $new_thumb_name = $site_upload->upload_file($thumb_file, "thumb", $cat_id, basename($new_name));
        if (!$new_thumb_name) {
          $log[] = "<b>".$lang['thumb_upload_error'].": ".$HTTP_POST_FILES[$thumb_file]['name']."</b><br />".$site_upload->get_upload_errors();
          @unlink(MEDIA_PATH."/".$cat_id."/".$new_name);
          $log[] = $lang['error_image_deleted'];
          $uploaderror = 1;
        }
        else {
          $log[] = "<b>".$lang['thumb_upload_success'].": ".$new_thumb_name."</b>";
        }
      }
      else {
        $new_thumb_name = $remote_thumb_file;
      }

      //Save to Database
      if (!$uploaderror) {
        $image_description = un_htmlspecialchars(trim($HTTP_POST_VARS['image_description_'.$i]));

        $image_keywords = trim($HTTP_POST_VARS['image_keywords_'.$i]);
        $image_keywords = preg_replace("/[\n\r]/is", " ", $image_keywords);
        $image_keywords = str_replace(","," ",$image_keywords);
        $image_keywords = ereg_replace("( ){2,}", " ", $image_keywords);

        $image_active = trim($HTTP_POST_VARS['image_active_'.$i]);
        $image_allow_comments = trim($HTTP_POST_VARS['image_allow_comments_'.$i]);

        $image_download_url = trim($HTTP_POST_VARS['image_download_url_'.$i]);

        $additional_field_sql = "";
        $additional_value_sql = "";
        if (!empty($additional_image_fields)) {
          $table_fields = $site_db->get_table_fields(IMAGES_TABLE);
          foreach ($additional_image_fields as $key => $val) {
            if (isset($HTTP_POST_VARS[$key.'_'.$i]) && isset($table_fields[$key])) {
              $additional_field_sql .= ", $key";
              $additional_value_sql .= ", '".un_htmlspecialchars(trim($HTTP_POST_VARS[$key.'_'.$i]))."'";
            }
          }
        }
        $current_time = time();
        $sql = "INSERT INTO ".IMAGES_TABLE."
                (cat_id, user_id, image_name, image_description, image_keywords, image_date, image_active, image_media_file, image_thumb_file, image_download_url, image_allow_comments".$additional_field_sql.")
                VALUES
                ($cat_id, $user_id, '$image_name', '$image_description', '$image_keywords', $current_time, $image_active, '$new_name', '$new_thumb_name', '$image_download_url', $image_allow_comments".$additional_value_sql.")";
        $result = $site_db->query($sql);
        $image_id = $site_db->get_insert_id();

        if ($result) {
          $search_words = array();
          foreach ($search_match_fields as $image_column => $match_column) {
            if (isset($HTTP_POST_VARS[$image_column.'_'.$i])) {
              $search_words[$image_column] = stripslashes($HTTP_POST_VARS[$image_column.'_'.$i]);
            }
          }
          add_searchwords($image_id, $search_words);
          $log[] = $lang['image_add_success'].": <b>".stripslashes($image_name)."</b> (".$new_name.")";
        }
        else {
          $log[] = $lang['image_add_error'].": <b>".stripslashes($image_name)."</b> (".$new_name.")";
        }
      }
      else {
        $log[] = $lang['no_db_entry'];
      }
      echo "<script language=javascript>\n showProgress();\n hideProgress();\n</script>";
      show_table_header($lang['image']." $i", 1);
      echo "<tr><td class=\"tablerow\">\n";
      echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
      foreach ($log as $val) {
        echo $val."<br />";
      }
      echo "</td></tr></table>\n";
      echo "</td></tr>\n";
      show_table_footer();
      echo "<br />";
    }
  }
  else {
    echo "<script language=javascript>\n showProgress();\n hideProgress();\n</script>";
    $msg = sprintf("<span class=\"marktext\">%s</span>", $lang['lostfield_error']);
    $action = "addimages";
  }
}

if ($action == "addimages") {
  if (isset($HTTP_GET_VARS['num_newimages']) || isset($HTTP_POST_VARS['num_newimages'])) {
    $num_newimages = (isset($HTTP_GET_VARS['num_newimages'])) ? intval($HTTP_GET_VARS['num_newimages']) : intval($HTTP_POST_VARS['num_newimages']);
  }
  else {
    $num_newimages = 1;
  }

  if ($msg != "") {
    printf("<b>%s</b>\n", $msg);
  }

  printf("<p>%s</p>\n", $lang['upload_note']);

  show_form_header("images.php", "saveimages", "form", 1);
  show_table_header($lang['nav_images_add'], 2);
  show_num_select_row("&nbsp;", "num_newimages", $lang['num_addnewimages_desc']);

  for ($i = 1; $i <= $num_newimages; $i++) {
    show_table_separator($lang['image']." ".$i, 2);
    show_upload_row($lang['image'], "file_".$i, "<br /><span class=smalltext>".$lang['allowed_mediatypes_desc'].str_replace(",",", ",$config['allowed_mediatypes'])."</span>");
    show_upload_row($lang['thumb'], "thumb_file_".$i, "<br /><span class=smalltext>".$lang['allowed_mediatypes_desc']." jpg, gif, png</span>");
    show_input_row($lang['field_download_url'].$lang['download_url_desc'], "image_download_url_".$i, "", $textinput_size);
    show_input_row($lang['field_image_name'], "image_name_".$i, "", $textinput_size);
    show_textarea_row($lang['field_description_ext'],"image_description_".$i, "", $textarea_size);
    show_textarea_row($lang['field_keywords_ext'], "image_keywords_".$i, "", $textarea_size);
    show_cat_select_row($lang['field_category'], 0, 3, $i);
    show_user_select_row($lang['user'], $user_info['user_id'], $i);
    show_radio_row($lang['field_free'], "image_active_".$i, 1);
    show_radio_row($lang['field_allow_comments'], "image_allow_comments_".$i, 1);
    show_additional_fields("image", array(), IMAGES_TABLE, $i);
  }
  show_hidden_input("num_newimages", $num_newimages);
  show_form_footer($lang['add'], $lang['reset'], 2, "", " onClick='showProgress()'");
}

if ($action == "modifyimages") {
  show_form_header("images.php", "findimages", "form");
  show_table_header($lang['nav_images_edit'], 2);
  show_input_row($lang['field_image_id_contains'], "image_id", "", $textinput_size);
  show_input_row($lang['field_image_name_contains'], "image_name", "", $textinput_size);
  show_input_row($lang['field_description_contains'], "image_description", "", $textinput_size);
  show_input_row($lang['field_keywords_contains'], "image_keywords", "", $textinput_size);
  show_cat_select_row($lang['field_category'], 0, 2);
  show_input_row($lang['field_image_file_contains'], "image_media_file", "", $textinput_size);
  show_input_row("User ID contains", "user_id", "", $textinput_size);
  show_radio_row("Activated", "image_active", 1);
  show_input_row($lang['field_username_contains'], "user_name", "", $textinput_size);
  show_input_row($lang['field_thumb_file_contains'], "image_thumb_file", "", $textinput_size);
  show_input_row($lang['field_thumb_file_contains'], "image_thumb_file", "", $textinput_size);
  show_input_row($lang['field_date_after'].$lang['date_format'], "dateafter", "", $textinput_size);
  show_input_row($lang['field_date_before'].$lang['date_format'], "datebefore", "", $textinput_size);
  show_input_row($lang['field_downloads_upper'], "downloadsupper", "", $textinput_size);
  show_input_row($lang['field_downloads_lower'], "downloadslower", "", $textinput_size);
  show_input_row($lang['field_rating_upper'], "ratingupper", "", $textinput_size);
  show_input_row($lang['field_rating_lower'], "ratinglower", "", $textinput_size);
  show_input_row($lang['field_votes_upper'], "votesupper", "", $textinput_size);
  show_input_row($lang['field_votes_lower'], "voteslower", "", $textinput_size);
  show_input_row($lang['field_hits_upper'], "hitsupper", "", $textinput_size);
  show_input_row($lang['field_hits_lower'], "hitslower", "", $textinput_size);
  show_table_separator($lang['sort_options'], 2);
  ?>
  <tr class="<?php echo get_row_bg(); ?>"><td><p><b><?php echo $lang['order_by'] ?></b></p></td><td><p>
  <select name="orderby">
  <option value="i.image_name"><?php echo $lang['field_image_name'] ?></option>
  <option value="i.cat_id"><?php echo $lang['field_category'] ?></option>
  <option value="i.image_date" selected><?php echo $lang['field_date'] ?></option>
  <option value="i.image_downloads"><?php echo $lang['field_downloads'] ?></option>
  <option value="i.image_rating"><?php echo $lang['field_rating'] ?></option>
  <option value="i.image_votes"><?php echo $lang['field_votes'] ?></option>
  <option value="i.image_hits"><?php echo $lang['field_hits'] ?></option>
  </select>
  <select name="direction">
  <option value="ASC"><?php echo $lang['asc'] ?></option>
  <option value="DESC" selected><?php echo $lang['desc'] ?></option>
  </select>
  </p></td></tr>
  <?php
  show_input_row($lang['results_per_page'], "limitnumber", 50);
  show_table_separator("Quick edit", 2);
  show_radio_row("Name", "editname", 0);
  show_radio_row("Description", "editdescription", 0);
  show_radio_row("Keyowords", "editkeywords", 0);
  show_radio_row("Date", "editdate", 0);
  show_form_footer($lang['search'], $lang['reset'], 2);
}

if ($action == "findimages") {
  if (!empty($error_log)) {
    show_table_header("Error Log:", 1);
    echo "<tr><td class=\"tablerow\">\n";
    echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
    echo "<b>".$lang['error_log_desc']."</b>\n<ul>\n";
    foreach ($error_log as $val) {
      printf("<li>%s</li>\n", $val);
    }
    echo "</ul>\n</td></tr></table>\n";
    echo "</td></tr>\n";
    show_table_footer();
  }
  $condition = "1=1";

  $image_id = intval($HTTP_POST_VARS['image_id']);
  if ($image_id != "") {
    $condition .= " AND INSTR(LCASE(i.image_id),'$image_id')>0";
  }
  $image_name = trim($HTTP_POST_VARS['image_name']);
  if ($image_name != "") {
    $condition .= " AND INSTR(LCASE(i.image_name),'".strtolower($image_name)."')>0";
  }
  $user_name = trim($HTTP_POST_VARS['user_name']);
  if ($user_name != "") {
    $condition .= " AND INSTR(LCASE(u.user_name),'".strtolower($user_name)."')>0";
  }
  $user_id = intval($HTTP_POST_VARS['user_id']);
  if ($user_id != "") {
    $condition .= " AND INSTR(LCASE(i.user_id),'$user_id')>0";
  }
  $image_description = trim($HTTP_POST_VARS['image_description']);
  if ($image_description != "") {
    $condition .= " AND INSTR(LCASE(i.image_description),'".strtolower($image_description)."')>0";
  }
  $image_keywords = trim($HTTP_POST_VARS['image_keywords']);
  if ($image_keywords != "") {
    $condition .= " AND INSTR(LCASE(i.image_keywords),'".strtolower($image_keywords)."')>0";
  }
  $cat_id = intval(trim($HTTP_POST_VARS['cat_id']));
  if ($cat_id != 0 && $cat_id != "") {
    $condition .= " AND i.cat_id = '$cat_id'";
  }
  $image_media_file = trim($HTTP_POST_VARS['image_media_file']);
  if ($image_media_file != "") {
    $condition .= " AND INSTR(LCASE(i.image_media_file),'".strtolower($image_media_file)."')>0";
  }
  $image_thumb_file = trim($HTTP_POST_VARS['image_thumb_file']);
  if ($image_thumb_file != "") {
    $condition .= " AND INSTR(LCASE(i.image_thumb_file),'".strtolower($image_thumb_file)."')>0";
  }
  $dateafter = trim($HTTP_POST_VARS['dateafter']);
  if ($dateafter != "") {
    $condition .= " AND i.image_date > UNIX_TIMESTAMP('$dateafter')";
  }
  $datebefore = trim($HTTP_POST_VARS['datebefore']);
  if ($datebefore != "") {
    $condition .= " AND i.image_date < UNIX_TIMESTAMP('$datebefore')";
  }
  $downloadslower = trim($HTTP_POST_VARS['downloadslower']);
  if ($downloadslower != "") {
    $condition .= " AND i.image_downloads < '$downloadslower'";
  }
  $downloadsupper = trim($HTTP_POST_VARS['downloadsupper']);
  if ($downloadsupper != "") {
    $condition .= " AND i.image_downloads > '$downloadsupper'";
  }
  $ratinglower = trim($HTTP_POST_VARS['ratinglower']);
  if ($ratinglower != "") {
    $condition .= " AND i.image_rating < '$ratinglower'";
  }
  $ratingupper = trim($HTTP_POST_VARS['ratingupper']);
  if ($ratingupper != "") {
    $condition .= " AND i.image_rating > '$ratingupper'";
  }
  $voteslower = trim($HTTP_POST_VARS['voteslower']);
  if ($voteslower != "") {
    $condition .= " AND i.image_votes < '$voteslower'";
  }
  $votesupper = trim($HTTP_POST_VARS['votesupper']);
  if ($votesupper != "") {
    $condition .= " AND i.image_votes > '$votesupper'";
  }
  $hitslower = trim($HTTP_POST_VARS['hitslower']);
  if ($hitslower != "") {
    $condition .= " AND i.image_hits < '$hitslower'";
  }
  $hitsupper = trim($HTTP_POST_VARS['hitsupper']);
  if ($hitsupper != "") {
    $condition .= " AND i.image_votes > '$hitsupper'";
  }
  $orderby = trim($HTTP_POST_VARS['orderby']);
  if ($orderby == "") {
    $orderby = "i.image_name";
  }

  $limitstart = (isset($HTTP_POST_VARS['limitstart'])) ? intval(trim($HTTP_POST_VARS['limitstart'])) : 0;
  if (!$limitstart) {
    $limitstart = 0;
  }
  
  $limitnumber = (isset($HTTP_POST_VARS['limitnumber'])) ? trim($HTTP_POST_VARS['limitnumber']) : 1;
  if (!$limitnumber) {
    $limitnumber = 1;
  }

  if (isset($HTTP_GET_VARS['direction']) || isset($HTTP_POST_VARS['direction'])) {
    $direction = (isset($HTTP_GET_VARS['direction'])) ? trim($HTTP_GET_VARS['direction']) : trim($HTTP_POST_VARS['direction']);
  }
  else {
    $direction = "ASC";
  }
  $image_active = (isset($HTTP_POST_VARS['image_active']) && $HTTP_POST_VARS['image_active']) ? 1 : 0;
  $condition .= " AND i.image_active = ".$image_active;
  $new_cat_id = isset($HTTP_POST_VARS['new_cat_id']) ? intval(trim($HTTP_POST_VARS['new_cat_id'])) : 0;
  $editname = isset($HTTP_POST_VARS['editname']) ? intval(trim($HTTP_POST_VARS['editname'])) : 0;
  $editdescription = isset($HTTP_POST_VARS['editdescription']) ? intval(trim($HTTP_POST_VARS['editdescription'])) : 0;
  $editkeywords = isset($HTTP_POST_VARS['editkeywords']) ? intval(trim($HTTP_POST_VARS['editkeywords'])) : 0;
  $editdate = isset($HTTP_POST_VARS['editdate']) ? intval(trim($HTTP_POST_VARS['editdate'])) : 0;
  $nextpage = isset($HTTP_POST_VARS['nextpage']) ? intval(trim($HTTP_POST_VARS['nextpage'])) : 0;
  $nextpageabort = isset($HTTP_POST_VARS['nextpageabort']) ? intval(trim($HTTP_POST_VARS['nextpageabort'])) : 0;
  if ($nextpage && !$nextpageabort) {
    $limitstart = $limitstart + $limitnumber;
  }
  $sql = "SELECT COUNT(*) AS images
          FROM ".IMAGES_TABLE." i
          LEFT JOIN ".USERS_TABLE." u ON (".get_user_table_field("u.", "user_id")." = i.user_id)
          WHERE $condition";
  $countimages = $site_db->query_firstrow($sql);
  $limitfinish = $limitstart + $limitnumber;

  $start = 0;
  if ($countimages['images'] > 0) {
    $start = $limitstart + 1;
  }
  echo $lang['found']." <b>".$countimages['images']."</b> ".$lang['showing']." <b>$start</b>-";
  if ($limitfinish > $countimages['images'] == 0) {
    echo "<b>".$limitfinish."</b>.";
  }
  else {
    echo "<b>".$countimages['images']."</b>.";
  }
  echo "<br />".$lang['no_image_found'];

  show_form_header("images.php", "removeimage", "form");
  echo "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\" align=\"center\"><tr><td class=\"tableborder\">\n<table cellpadding=\"3\" cellspacing=\"1\" border=\"0\" width=\"100%\">\n";
  if ($countimages['images'] > 0) {
    echo "<tr class=\"tableseparator\">\n";
    if (!$editname && !$editdescription && !$editkeywords && !$editdate) {
      echo "<td class=\"tableseparator\"><input name=\"allbox\" type=\"checkbox\" onClick=\"CheckAll();\" /></td>\n";
    }
    echo "<td class=\"tableseparator\">&nbsp;</td><td class=\"tableseparator\">".$lang['field_image_name']."</td>\n";
    if ($editdescription) {
      echo "<td class=\"tableseparator\">".$lang['field_description']."</td>\n";
    }
    if ($editkeywords) {
      echo "<td class=\"tableseparator\">".$lang['field_keywords']."</td>\n";
    }
    echo "<td class=\"tableseparator\">".$lang['field_category']."</td>\n<td class=\"tableseparator\">".$lang['field_username']."</td>\n<td class=\"tableseparator\">".$lang['field_date']."</td>\n<td class=\"tableseparator\">".$lang['options']."</td>\n</tr>\n";

    $sql = "SELECT i.image_id, i.cat_id, i.user_id, i.image_name, i.image_media_file, i.image_thumb_file, i.image_date, i.image_description, i.image_keywords".get_user_table_field(", u.", "user_name")."
            FROM ".IMAGES_TABLE." i
            LEFT JOIN ".USERS_TABLE." u ON (".get_user_table_field("u.", "user_id")." = i.user_id)
            WHERE $condition
            ORDER BY $orderby $direction
            LIMIT ".(($limitstart) ? $limitstart-1 : 0).", $limitnumber";
    $result = $site_db->query($sql);
    $i = 0;
    while ($image_row = $site_db->fetch_array($result)) {
      echo "<tr class=\"".get_row_bg()."\">";
      if ($editname || $editdescription || $editkeywords || $editdate) {
        echo "<input type=\"hidden\" name=\"selectimages[$i]\" value=\"".$image_row['image_id']."\" />";
      }
      else {
        echo "<td><input type=\"checkbox\" name=\"selectimages[]\" value=\"".$image_row['image_id']."\" /></td>";
      }
      $thumb_src = ROOT_PATH.THUMB_DIR."/".$image_row['cat_id']."/".$image_row['image_thumb_file'];
      $dim = $thumbsize;
      $width = $dim;
      $height = $dim;
      $thumb_size = get_resize2($thumb_src, $dim);
      $width = $thumb_size[0];
      $height = $thumb_size[1];

      echo "<td align=\"center\"><a href=\"".$site_sess->url(ROOT_PATH."details.php?".URL_IMAGE_ID."=".$image_row['image_id'])."\" target=_blank><img src=\"".((empty($image_row['image_thumb_file'])) ? ICON_PATH."/".get_file_extension($image_row['image_media_file']).".gif" : ((is_remote($image_row['image_thumb_file'])) ? $image_row['image_thumb_file'] : $thumb_src))."\" width=\"".$width."\" height=\"".$height."\" border=\"1\" alt=\"\" /></a></td><td>";
      if ($editname) {
        echo "<input name=\"name[$i]\" value=\"".str_replace("\"", "&quot;", stripslashes($image_row['image_name']))."\" /><br />";
      }
      else {
        echo "<b><a href=\"".$site_sess->url(ROOT_PATH."details.php?".URL_IMAGE_ID."=".$image_row['image_id'])."\" target=_blank>".$image_row['image_name']."</a></b> ";
      }
      echo "(".$image_row['image_media_file'];

      if (!get_file_path($image_row['image_media_file'], "media", $image_row['cat_id'], 1, 0)) {
        echo " <b class=\"marktext\">!</b>";
      }
      echo ")</td>\n";
      if ($editdescription) {
        echo "<td><textarea cols=\"$cols\" rows=\"$rows\" name=\"description[$i]\">".stripslashes($image_row['image_description'])."</textarea></td>\n";
      }
      if ($editkeywords) {
        echo "<td><textarea cols=\"$cols\" rows=\"$rows\" name=\"keywords[$i]\">".stripslashes($image_row['image_keywords'])."</textarea></td>\n";
      }
      echo "<td><a href=\"".$site_sess->url(ROOT_PATH."categories.php?".URL_CAT_ID."=".$image_row['cat_id'])."\" target=\"_blank\">".htmlspecialchars($cat_cache[$image_row['cat_id']]['cat_name'])." (ID: <b>".$image_row['cat_id']."</b>)</a></td>\n";
      $show_user_name = htmlspecialchars($image_row[$user_table_fields['user_name']]);
      if ($image_row['user_id'] != GUEST && empty($url_show_profile)) {
        $show_user_name = "<a href=\"".$site_sess->url(ROOT_PATH."member.php?action=showprofile&".URL_USER_ID."=".$image_row['user_id'])."\" target=\"_blank\">$show_user_name</a>";
      }
      echo "<td>".$show_user_name."</td>\n";
      echo "<td>";
      if ($editdate) {
        echo "<input name=\"image_date[$i]\" value=\"".format_date("Y-m-d H:i:s", $image_row['image_date'])."\" /><br />yyyy-mm-dd hh:mm:ss";
      }
      else {
        echo format_date($config['date_format'], $image_row['image_date']);
      }
      echo "</td>\n";
      echo "<td><p>";
      show_text_link($lang['edit'],"images.php?action=editimage&image_id=".$image_row['image_id'], $target);
      show_text_link($lang['delete'],"images.php?action=removeimage&image_id=".$image_row['image_id'], $target);
      echo "</p></td>\n";
      echo "</tr>\n";
      $i++;
    }

    show_hidden_input("image_id", $image_id);
    show_hidden_input("image_name", $image_name, 1);
    show_hidden_input("user_id", $user_id);
    show_hidden_input("user_name", $user_name, 1);
    show_hidden_input("image_active", $image_active, 1);
    show_hidden_input("image_description", $image_description, 1);
    show_hidden_input("image_keywords", $image_keywords, 1);
    show_hidden_input("cat_id", $cat_id);
    show_hidden_input("image_media_file", $image_media_file, 1);
    show_hidden_input("image_thumb_file", $image_thumb_file, 1);
    show_hidden_input("dateafter", $dateafter);
    show_hidden_input("datebefore", $datebefore);
    show_hidden_input("downloadsupper", $downloadsupper);
    show_hidden_input("downloadslower", $downloadslower);
    show_hidden_input("ratingupper", $ratingupper);
    show_hidden_input("ratinglower", $ratinglower);
    show_hidden_input("votesupper", $votesupper);
    show_hidden_input("voteslower", $voteslower);
    show_hidden_input("hitsupper", $hitsupper);
    show_hidden_input("hitslower", $hitslower);

    show_hidden_input("orderby", $orderby, 1);
    show_hidden_input("direction", $direction, 1);
    show_hidden_input("limitstart", $limitstart);
    show_hidden_input("limitnumber", $limitnumber);
    show_hidden_input("editname", $editname);
    show_hidden_input("editdescription", $editdescription);
    show_hidden_input("editkeywords", $editkeywords);
    show_hidden_input("editdate", $editdate);
    $n = 0;
    $n = ($editdescription) ? ++$n : $n;
    $n = ($editkeywords) ? ++$n : $n;   
    echo "<tr class=\"tablefooter\">\n<td colspan=\"".(5+$n)."\" align=\"left\" class=\"tableseparator\">\n&nbsp;";
    if ($editname || $editdescription || $editkeywords || $editdate) {
      echo "<input type=\"submit\" value=\"  ".$lang['save']."   \" class=\"button\" name=\"action\" onClick=\"action.value='save';\">&nbsp;\n";
      if ($limitnumber != 5000 && $limitfinish < $countimages['images']) {
        echo "<input type=\"checkbox\" value=\"1\" class=\"button\" name=\"nextpage\"".(($nextpage) ? " checked" : "").">&nbsp;Continue on next page\n";
      }
    }
    else {
      echo "<input type=\"submit\" value=\"  ".$lang['edit']."   \" class=\"button\" name=\"action\" onClick=\"action.value='edit';\">\n";
      echo "<input type=\"submit\" value=\"  ".$lang['delete']."   \" class=\"button\">\n&nbsp;&nbsp;&nbsp;";
      $category = "\n<select name=\"new_cat_id\" class=\"categoryselect\">\n";
      $category .= "<option value=\"0\">".$lang['select_category']."</option>\n";
      $category .= "<option value=\"0\">-------------------------------</option>\n";
      $drop_down_cat_cache = array();
      $drop_down_cat_cache = $cat_parent_cache;
      $category .= get_category_dropdown_bits($new_cat_id);
      $category .= "</select>\n";
      echo $category;
      echo "<input type=\"submit\" value=\"  ".$lang['copy']."   \" class=\"button\" name=\"action\" onClick=\"action.value='copy';\">\n";
      echo "<input type=\"submit\" value=\"  ".$lang['move']."   \" class=\"button\" name=\"action\" onClick=\"action.value='move';\">\n";
      echo "<a alt=\"If checked the original date when image was added will not be changed\\notherwise current date will be used\"><input type=\"checkbox\" name=\"date\" value=\"1\" checked />&nbsp;Save original date </a>\n";
      if (empty($user_select_row_cache)) {
        $sql = "SELECT ".get_user_table_field("", "user_id").get_user_table_field(", ", "user_name")."
                FROM ".USERS_TABLE."
                WHERE ".get_user_table_field("", "user_id")." <> ".GUEST."
                ORDER BY ".get_user_table_field("", "user_name")." ASC";
        $result = $site_db->query($sql);
        $user_select_row_cache = array();
        while ($row = $site_db->fetch_array($result)) {
          $user_select_row_cache[$row[$user_table_fields['user_id']]] = $row[$user_table_fields['user_name']];
        }
      }
      echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<select name=\"owner\" class=\"categoryselect\">\n";
      echo "<option value=\"".GUEST."\">".$lang['userlevel_guest']."</option>\n";
      echo "<option value=\"".GUEST."\">-------------------------------</option>\n";
      foreach ($user_select_row_cache as $key => $val) {
        echo "<option value=\"".$key."\"";
        if (($owner && $key == $owner) || (!$owner && $key == $user_info['user_id'])) {
          echo " selected=\"selected\"";
        }
        echo ">".$val."</option>\n";
      }
      echo "</select>\n";
      echo "<input type=\"submit\" value=\" ".$lang['changeowner']." \" class=\"button\" name=\"action\" onClick=\"action.value='changeowner';\">\n";
    }
    echo "&nbsp;\n</td>\n";
    echo "</tr>\n</table>\n</td>\n</tr>\n</table>\n";

    echo "</form>\n";
  }
  else {
    show_description_row($lang['no_search_results'], 6);
    show_form_footer("", "");
  }

  echo "<div align=\"right\">";
  echo "<form action=\"".$site_sess->url("images.php")."\" name=\"form2\" method=\"post\">\n";

    show_hidden_input("action", "findimages");
    show_hidden_input("image_id", $image_id);
    show_hidden_input("image_name", $image_name, 1);
    show_hidden_input("user_id", $user_id);
    show_hidden_input("user_name", $user_name, 1);
    show_hidden_input("image_active", $image_active, 1);
    show_hidden_input("image_description", $image_description, 1);
    show_hidden_input("image_keywords", $image_keywords, 1);
    show_hidden_input("cat_id", $cat_id);
    show_hidden_input("image_media_file", $image_media_file, 1);
    show_hidden_input("image_thumb_file", $image_thumb_file, 1);
    show_hidden_input("dateafter", $dateafter);
    show_hidden_input("datebefore", $datebefore);
    show_hidden_input("downloadsupper", $downloadsupper);
    show_hidden_input("downloadslower", $downloadslower);
    show_hidden_input("ratingupper", $ratingupper);
    show_hidden_input("ratinglower", $ratinglower);
    show_hidden_input("votesupper", $votesupper);
    show_hidden_input("voteslower", $voteslower);
    show_hidden_input("hitsupper", $hitsupper);
    show_hidden_input("hitslower", $hitslower);

    show_hidden_input("orderby", $orderby, 1);
    show_hidden_input("direction", $direction, 1);
    show_hidden_input("limitstart", $limitstart + $limitnumber);
    show_hidden_input("limitnumber", $limitnumber);
    show_hidden_input("editname", $editname);
    show_hidden_input("editdescription", $editdescription);
    show_hidden_input("editkeywords", $editkeywords);
    show_hidden_input("editdate", $editdate);
    show_hidden_input("nextpage", $nextpage);
    show_hidden_input("nextpageabort", 1);
  if ($limitnumber != 5000 && $limitfinish < $countimages['images']) {
    echo "<input type=\"submit\" value=\"   ".$lang['search_next_page']."   \" class=\"button\">\n";
  }
  echo "<input type=\"submit\" value=\"   ".$lang['back']."   \" onclick=\"".(($limitstart) ? "limitstart.value = '".($limitstart - $limitnumber)."'" : "action.value = ''")."\" class=\"button\">\n";
  echo "</form>";
  echo "</div>";
}

show_admin_footer();
?>