<?php
/**************************************************************************
 *                                                                        *
 *    4images - A Web Based Image Gallery Management System               *
 *    ----------------------------------------------------------------    *
 *                                                                        *
 *             File: checkimages.php                                      *
 *        Copyright: (C) 2002 Jan Sorgalla                                *
 *            Email: jan@4homepages.de                                    *
 *              Web: http://www.4homepages.de                             *
 *    Scriptversion: 1.8                                                  *
 *    File version: 2.10.3                                                 *
 *                                                                        *
 *    Never released without support from: Nicky (http://www.nicky.net)   *
 *                                                                        *
 **************************************************************************
 *                                                                        *
 *    Dieses Script ist KEINE Freeware. Bitte lesen Sie die Lizenz-       *
 *    bedingungen (Lizenz.txt) fr weitere Informationen.                 *
 *    ---------------------------------------------------------------     *
 *    This script is NOT freeware! Please read the Copyright Notice       *
 *    (Licence.txt) for further information.                              *
 *                                                                        *
 *************************************************************************/

define('IN_CP', 1);
define('ROOT_PATH', './../');
require('admin_global.php');

//--------| Default Settings |-------------

$quality_default = ($config['auto_image_quality']) ? $config['auto_image_quality'] : 85; //image quality
$quality_thumbs_default = $config['auto_thumbnail_quality']; //thumbnail quality
$dimension_default = $config['max_image_width']; //image dimension
$dimension_thumbs_default = $config['auto_thumbnail_dimension']; //thumbnail demension
$max_dimension_default = 600; //displayed in preview image dimension (not image resizing)
$num_newimages_default = 30; //images per circle
$big_folder_default = "big"; //name of the "big" folder where original image will be copied to, if its bigger then size set in the settings.
$big_annotate = 0; //add annotation to the "original" images in "big" folder? (0 or 1)
$backup_orig = ""; //leave empty if u dont want backup files when it needed resize or add watermark (to preserve IPTC and EXIF headers) NO TRAILING SLASH!
$filter = 1; //use a filter on filenames. Any non-standart characters will be replaced with _ or just be deleted. (0 or 1)
$thumbpreview = 1; //create temporary thumbnails for preview if no original was found. (only for none-detailed view) (0 or 1)
$thumbpreview_quality = 70; //quality for temporary thumbnails
$thumbpreview_dimensions = 50; //max dimensions for temporary thumbnails
$thumbpreview_tempdir = ROOT_PATH.'data/temp'; //directory for temporary files. Must be writable (CHMOD 777).
$rescan = 1; //rescan for new images after first portion of images added (0 or 1)
if (!$mode)
{
  $annotate_default = (isset($config['annotation_use'])) ? $config['annotation_use'] : 0; //add annotation to the images (require "Annotation MOD" by SLL)
  $big_default = 0; //save original image (0 or 1)
  $auto_iptc_default = 0; //auto insert IPTC (0 or 1)
  $date_iptc_default = 0; //auto insert date from IPTC (0 or 1)
  $detailed_default = 0; //detailed view (0 or 1)
  $auto_resize_default = 1; //resize images (0 or 1)
  $auto_thumbs_default = 1; //create thumbs (0 or 1)
  $subcats_default = 0; //include subcategories (0 or 1)
}

//----------| End Settings |---------------

if ($action == "showthumb" && $mode)
{
  $result = true;
  if (!@is_dir($thumbpreview_tempdir))
  {
    $oldumask = umask(0);
    $result = mkdir($thumbpreview_tempdir);
    umask($oldumask);
    if (!@is_dir($thumbpreview_tempdir) || !$result)
    {
      $result = mkdir($thumbpreview_tempdir, 0755);
    }
  }

  $thumb = ICON_PATH."/404.gif";
  $file = MEDIA_PATH."/".(($cat_id) ? $cat_id ."/" : "").$mode;
  $delete = false;
  if ($result && $img = @getimagesize($file))
  {
    if ($img[2] >= 0 && $img[2] < 4)
    {
      $thumb = $file;
    }
    else
    {
      $thumb = ICON_PATH."/".strtolower(substr(strrchr($mode,"."), 1)).".gif";
    }
	}
  else
  {
    $thumb = ICON_PATH."/".strtolower(substr(strrchr($mode,"."), 1)).".gif";
  }
	$file = $thumbpreview_tempdir."/".MD5(time().microtime());
  require(ROOT_PATH.'includes/image_utils.php');
	$convert_options = init_convert_options();
	$type = substr(strrchr($thumb,"."), 1);
	if (!$convert_options['convert_error'])
  {
    if (create_thumbnail($thumb, $file, $thumbpreview_quality, $thumbpreview_dimensions, 1))
    {
      $delete = true;
      $thumb = $file;
    }
	}
  header("Content-Type: image/".$type);
  header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");             // turn off caching
  header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
  header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
  @readfile($thumb);
  if ($delete)
  {
    @unlink($file);
  }
  exit;
}

include(ROOT_PATH.'includes/search_utils.php');

function backup($src, $dest, $name, $cat_id)
{
  $dest .= "/".$cat_id;
  $result = true;
  if (!@is_dir($dest))
  {
    $oldumask = umask(0);
    $result = mkdir($dest);
    umask($oldumask);
    if (!@is_dir($dest) || !$result)
    {
      $result = mkdir($dest, 0755);
    }
  }
  if ($result)
  {
    return copy($src, $dest."/".$name);
  }
  return false;
}
function get_subcats($cat_id = 0, $cid = 0) {
  global $sub_cat_cache, $cat_cache, $cats;

  if (!isset($sub_cat_cache[$cid])) {
    return "";
  }
  foreach ($sub_cat_cache[$cid] as $key => $category_id) {
    $cats[] = $category_id;
    get_subcats($cat_id, $category_id);
  }
  unset($sub_cat_cache[$cid]);
}

if ($action == "")
{
  $action = "checkimages";
}
$status = 0;

function get_category_dropdown_check($cat_id = 0)
{
  global $lang, $drop_down_cat_cache, $cat_parent_cache;
    $category = "\n<select name=\"cat_id_p\" class=\"categoryselect\">\n";
    $category .= "<option value=\"0\">".$lang['all_categories']."</option>\n";
    $category .= "<option value=\"0\">-------------------------------</option>\n";

  $drop_down_cat_cache = array();
  $drop_down_cat_cache = $cat_parent_cache;
  $category .= get_category_dropdown_bits($cat_id);
  $category .= "</select>\n";
  return $category;
}
show_admin_header($inbox_new);

if ($action == "savenewimages")
{
  @include(ROOT_PATH."includes/db_field_definitions.php");

  $date = time();
  $error = array();
  $num_newimages = $HTTP_POST_VARS['num_newimages'];
  $detailed = $HTTP_POST_VARS['detailed'];
  $auto_resize = (isset($HTTP_POST_VARS['auto_resize']) && $HTTP_POST_VARS['auto_resize'] == 1) ? 1 : 0;
  $auto_thumbs = (isset($HTTP_POST_VARS['auto_thumbs']) && $HTTP_POST_VARS['auto_thumbs'] == 1) ? 1 : 0;
  $dimension = (isset($HTTP_POST_VARS['dimension'])) ? intval($HTTP_POST_VARS['dimension']) : $dimension_default;
  $resize_type = (isset($HTTP_POST_VARS['resize_type'])) ? intval($HTTP_POST_VARS['resize_type']) : 1;
  $quality = (isset($HTTP_POST_VARS['quality']) && intval($HTTP_POST_VARS['quality']) && intval($HTTP_POST_VARS['quality']) <= 100) ? intval($HTTP_POST_VARS['quality']) : $quality_default;
  $dimension_thumbs = (isset($HTTP_POST_VARS['dimension_thumbs'])) ? intval($HTTP_POST_VARS['dimension_thumbs']) : $dimension_thumbs_default;
  $resize_type_thumbs = (isset($HTTP_POST_VARS['resize_type_thumbs'])) ? intval($HTTP_POST_VARS['resize_type_thumbs']) : 1;
  $quality_thumbs = (isset($HTTP_POST_VARS['quality_thumbs']) && intval($HTTP_POST_VARS['quality_thumbs']) && intval($HTTP_POST_VARS['quality_thumbs']) <= 100) ? intval($HTTP_POST_VARS['quality_thumbs']) : $quality_thumbs_default;
  $big = (isset($HTTP_POST_VARS['big']) && $HTTP_POST_VARS['big'] == 1) ? 1 : $big_default;
  $annotate = (isset($HTTP_POST_VARS['annotate']) && $HTTP_POST_VARS['annotate'] == 1) ? 1 : $annotate_default;
  $big_folder = (isset($HTTP_POST_VARS['big_folder'])) ? trim($HTTP_POST_VARS['big_folder']) : $big_folder_default;
  for ($i = 1; $i <= $num_newimages; $i++)
  {
    $addimage = (isset($HTTP_POST_VARS['addimage_'.$i]) && $HTTP_POST_VARS['addimage_'.$i] == 1) ? 1 : 0;
    if ($addimage)
    {
      $image_name = trim($HTTP_POST_VARS['image_name_'.$i]);
      $cat_id = intval($HTTP_POST_VARS['cat_id_'.$i]);
      $image_download_url = (isset($HTTP_POST_VARS['image_download_url_'.$i])) ? trim($HTTP_POST_VARS['image_download_url_'.$i]) : "";

      if ($image_name == "")
      {
        $error['image_name_'.$i] = 1;
      }
      if ($cat_id == 0)
      {
        $error['cat_id_'.$i] = 1;
      }
      if ($image_download_url != "" && !is_remote($image_download_url) && !is_local_file($image_download_url))
      {
        $error['image_download_url_'.$i] = 1;
      }

      if (!empty($additional_image_fields))
      {
        foreach ($additional_image_fields as $key => $val)
        {
          if (isset($HTTP_POST_VARS[$key.'_'.$i]) && intval($val[2]) == 1 && trim($HTTP_POST_VARS[$key.'_'.$i]) == "")
          {
            $error[$key.'_'.$i] = 1;
          }
        }
      }
    }
  }
  if (empty($error))
  {
		require(ROOT_PATH.'includes/image_utils.php');
		$no_resize = 0;
		$convert_options = init_convert_options();
		if ($convert_options['convert_error'])
    {
			$no_resize = 1;
		}
    show_table_header($lang['nav_images_check']." log", 1);
    echo "<tr>\n<td class=\"tablerow\">\n";
    echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td>&nbsp;</td><td>\n";
    $n = 0;
    for ($i = 1; $i <= $num_newimages; $i++)
    {
      $log = array();
      $backup = false;
      $addimage = (isset($HTTP_POST_VARS['addimage_'.$i]) && $HTTP_POST_VARS['addimage_'.$i] == 1) ? 1 : 0;
      if ($addimage)
      {
        $image_media_file = trim($HTTP_POST_VARS['image_media_file_'.$i]);
        $image_thumb_file = trim($HTTP_POST_VARS['image_thumb_file_'.$i]);
        $image_name = trim($HTTP_POST_VARS['image_name_'.$i]);

        $cat_id = intval($HTTP_POST_VARS['cat_id_'.$i]);
        $old_cat_id = intval($HTTP_POST_VARS['old_cat_id_'.$i]);

        $user_id = (isset($HTTP_POST_VARS['user_id_'.$i]) && intval($HTTP_POST_VARS['user_id_'.$i]) != 0) ? intval($HTTP_POST_VARS['user_id_'.$i]) : "";
        $user_id = ($user_id) ? $user_id : ((isset($HTTP_POST_VARS['user_id']) && intval($HTTP_POST_VARS['user_id']) != 0) ? intval($HTTP_POST_VARS['user_id']) : $user_info['user_id']);

        $image_description = (isset($HTTP_POST_VARS['image_description_'.$i])) ? trim($HTTP_POST_VARS['image_description_'.$i]) : "";
        $image_date = (isset($HTTP_POST_VARS['image_date_'.$i])) ? ((trim($HTTP_POST_VARS['image_date_'.$i] != "")) ? "UNIX_TIMESTAMP('".trim($HTTP_POST_VARS['image_date_'.$i])."')" : time()) : time();
        $image_download_url = (isset($HTTP_POST_VARS['image_download_url_'.$i])) ? trim($HTTP_POST_VARS['image_download_url_'.$i]) : "";

        if (isset($HTTP_POST_VARS['image_keywords_'.$i]))
        {
          $image_keywords = trim($HTTP_POST_VARS['image_keywords_'.$i]);
          $image_keywords = preg_replace("/[\n\r]/is", " ", $image_keywords);
          $image_keywords = str_replace(","," ",$image_keywords);
          $image_keywords = ereg_replace("( ){2,}", " ", $image_keywords);
        }
        else
        {
          $image_keywords = "";
        }
        $image_active = intval($HTTP_POST_VARS['image_active_'.$i]);
        $image_allow_comments = intval($HTTP_POST_VARS['image_allow_comments_'.$i]);

        $additional_field_sql = "";
        $additional_value_sql = "";
        if (!empty($additional_image_fields))
        {
          $table_fields = $site_db->get_table_fields(IMAGES_TABLE);
          foreach ($additional_image_fields as $key => $val)
          {
            if (isset($HTTP_POST_VARS[$key.'_'.$i]) && isset($table_fields[$key]))
            {
              $additional_field_sql .= ", $key";
              $additional_value_sql .= ", '".un_htmlspecialchars(trim($HTTP_POST_VARS[$key.'_'.$i]))."'";
            }
          }
        }

        $log[] = "Working on <b>".MEDIA_DIR.(($old_cat_id != 0) ? "/".$old_cat_id : "")."/".stripslashes($image_media_file)."</b> file:";
        if ($filter && preg_match("/( |%20|[^-\._a-zA-Z0-9])/", stripslashes($image_media_file)))
        {
          $image_media_file_backup = $image_media_file;
          $image_media_file = stripslashes($image_media_file);
          $file = str_replace(" ", "_", $image_media_file);
          $file = str_replace("%20", "_", $file);
          $file = preg_replace("/[^-\._a-zA-Z0-9]/", "", $file);
          $oldwd = getcwd();
          $n = 2;
          $copy = "";
          $file_name = substr($file,0,(strlen($file)-strlen(strrchr($file,"."))));
          $file_ext = substr(strrchr($file,"."), 1);
          chdir(realpath(MEDIA_PATH.(($old_cat_id != 0) ? "/".$old_cat_id : "")));
          while (file_exists($file_name.$copy.".".$file_ext)) {
            $copy = "_".$n;
            $n++;
          }
          if (rename(basename($image_media_file), basename($file)))
          {
            $log[] = "File ranamed media file from <b>".$image_media_file."</b> to <b>".$file."</b>";
            $image_media_file = $file;
          }
          else
          {
            $log[] = "<u>Error</u> ranaming media file from <b>".$image_media_file."</b> to <b>".$file."</b>";
            $image_media_file = $image_media_file_backup;
          }
          chdir($oldwd);
        }
        if ($filter && preg_match("/( |%20|[^-\._a-zA-Z0-9])/", stripslashes($image_thumb_file)))
        {
          $image_thumb_file_backup = $image_thumb_file;
          $image_thumb_file = stripslashes($image_thumb_file);
          $file = str_replace(" ", "_", $image_thumb_file);
          $file = str_replace("%20", "_", $file);
          $file = preg_replace("/[^-\._a-zA-Z0-9]/", "", $file);
          $oldwd = getcwd();
          $n = 2;
          $copy = "";
          $file_name = substr($file,0,(strlen($file)-strlen(strrchr($file,"."))));
          $file_ext = substr(strrchr($file,"."), 1);
          chdir(realpath(THUMB_PATH.(($old_cat_id != 0) ? "/".$old_cat_id : "")));
          while (file_exists($file_name.$copy.".".$file_ext)) {
            $copy = "_".$n;
            $n++;
          }
          if (rename(basename(stripslashes($image_thumb_file)), basename($file)))
          {
            $log[] = "File ranamed thumbnail file from <b>".$image_thumb_file."</b> to <b>".$file."</b>";
            $image_thumb_file = $file;
          }
          else
          {
            $log[] = "<u>Error</u> ranaming thumbnail file from <b>".$image_thumb_file."</b> to <b>".$file."</b>";
            $image_thumb_file = $image_thumb_file_backup;
          }
          chdir($oldwd);
        }
        if ($cat_id != $old_cat_id)
        {
          $image_media_file = copy_media($image_media_file, $old_cat_id, $cat_id);
          if (file_exists(MEDIA_PATH.(($old_cat_id != 0) ? "/".$old_cat_id : "")."/".$image_media_file))
          {
            $log[] = "Copied file into <b>".MEDIA_DIR.(($cat_id != 0) ? "/".$cat_id : "")."</b> folder.";
          }
          $image_thumb_file = copy_thumbnail($image_media_file, $image_thumb_file, $old_cat_id, $cat_id);
          if (file_exists(THUMB_PATH.(($old_cat_id != 0) ? "/".$old_cat_id : "")."/".$image_thumb_file))
          {
            $log[] = "Copied thumbnail into <b>".THUMB_DIR.(($cat_id != 0) ? "/".$cat_id : "")."</b> folder.";
          }
        }
				$file = MEDIA_PATH.(($cat_id != 0) ? "/".$cat_id : "")."/".$image_media_file;
				if ($big)
        {
				  $big_file = MEDIA_PATH."/".$cat_id."/".$big_folder."/".$image_media_file;
          if (file_exists($big_file))
          {
    				if ($big_annotate && $annotate && ($image_info = getimagesize($big_file)) && $image_info[2] > 0 && $image_info[2] < 4)
    				{
              if ($backup_orig)
              {
            		if ($backup = backup($big_file, $backup_orig, $image_media_file, $cat_id))
            		{
									$log[] = "Backup original file into <b>".$backup_orig."/".$cat_id."/</b> folder.";
								}
								else
								{
								  $log[] = "<u>Error</u> copying original file into <b>".$backup_orig."/".$cat_id."/</b> folder.";
								}
            	}
    				  include_once(ROOT_PATH.'includes/annotate.php');
              if (annotate_image($big_file))
    				  {
    				    $log[] = "Added annotation in <b>".MEDIA_DIR."/".$cat_id."/".$big_folder."/".stripslashes($image_media_file)."</b> file.";
    				  }
    				  else
    				  {
    				    $log[] = "<u>Error</u> adding annotation in <b>".MEDIA_DIR."/".$cat_id."/".$big_folder."/".stripslashes($image_media_file)."</b> file.";
    				  }
    				}
					}
				}
	      if ($auto_resize && file_exists($file) && !$no_resize)
        {
	        if ($image_info = getimagesize($file))
          {
		        if ($image_info[2] == 1 || $image_info[2] == 2 || $image_info[2] == 3)
            {
		          $ok = 0;
		          if ($resize_type == 1 && ($image_info[0] > $dimension || $image_info[1] > $dimension))
              {
		            $ok = 1;
		          }
		          elseif ($resize_type == 2 && $image_info[0] > $dimension)
              {
		            $ok = 1;
		          }
		          elseif ($resize_type == 3 && $image_info[1] > $dimension)
              {
		            $ok = 1;
		          }
							if ($ok)
              {
                if ($backup_orig && !$backup)
                {
              		if ($backup = backup($file, $backup_orig, $image_media_file, $cat_id))
              		{
 										$log[] = "Backup original file into <b>".$backup_orig."/".$cat_id."/</b> folder.";
 									}
									else
									{
									  $log[] = "<u>Error</u> copying original file into <b>".$backup_orig."/".$cat_id."/</b> folder.";
									}
              	}
								if ($big)
                {
								  $src = MEDIA_PATH."/".$cat_id."/".$big_folder;
									$result = true;
								  if (!@is_dir($src))
                  {
								    $oldumask = umask(0);
								    $result = mkdir($src);
								    umask($oldumask);
								    if (!@is_dir($src) || !$result)
                    {
								      $result = mkdir($src, 0755);

								    }
                    if ($result)
                    {
                      $log[] = "Created <b>".MEDIA_DIR."/".$cat_id."/".$big_folder."/</b> folder.";
                    }
                    else
                    {
                      $log[] = "<u>Error</u> creating <b>".MEDIA_DIR."/".$cat_id."/".$big_folder."/</b> folder.";
                    }
								  }
									if ($result == true){
									  $big_file = $src."/".$image_media_file;
										if (copy($file, $big_file))
										{
										  $log[] = "Copied original file into <b>".MEDIA_DIR."/".$cat_id."/".$big_folder."/</b> folder.";
										  $image_info = getimagesize($big_file);
              				if ($big_annotate && $annotate && $image_info && $image_info[2] > 0 && $image_info[2] < 4)
              				{
              				  include_once(ROOT_PATH.'includes/annotate.php');
              				  if (annotate_image($big_file))
              				  {
              				    $log[] = "Added annotation in <b>".MEDIA_DIR."/".$cat_id."/".$big_folder."/".stripslashes($image_media_file)."</b> file.";
              				  }
              				  else
              				  {
              				    $log[] = "<u>Error</u> adding annotation in <b>".MEDIA_DIR."/".$cat_id."/".$big_folder."/".stripslashes($image_media_file)."</b> file.";
              				  }
              				}
										}
										else
										{
										  $log[] = "<u>Error</u> copying original file into <b>".MEDIA_DIR."/".$cat_id."/".$big_folder."/</b> folder.";
										}
									}
								}
				        if (resize_image($file, $quality, $dimension, $resize_type))
                {
				          $log[] = "Image resized.";
				        }
				        else
                {
	          			$log[] = "<u>Error</u> resizing image.";
				        }
							}
		        }
		      }
		    }
				$file = MEDIA_PATH."/".$cat_id."/".stripslashes($image_media_file);
				$image_info = getimagesize($file);
				if ($annotate && $image_info && $image_info[2] > 0 && $image_info[2] < 4)
				{
          if ($backup_orig && !$backup)
          {
        		if ($backup = backup($file, $backup_orig, $image_media_file, $cat_id))
        		{
							$log[] = "Backup original file into <b>".$backup_orig."/".$cat_id."/</b> folder.";
						}
						else
						{
						  $log[] = "<u>Error</u> copying original file into <b>".$backup_orig."/".$cat_id."/</b> folder.";
						}
        	}
				  include_once(ROOT_PATH.'includes/annotate.php');
				  if (annotate_image($file))
				  {
				    $log[] = "Added annotation in <b>".MEDIA_DIR."/".$cat_id."/".stripslashes($image_media_file)."</b> file.";
				  }
				  else
				  {
				    $log[] = "<u>Error</u> adding annotation in <b>".MEDIA_DIR."/".$cat_id."/".stripslashes($image_media_file)."</b> file.";
				  }
				}
				$file_thumb = THUMB_PATH."/".$cat_id."/".stripslashes($image_media_file);
	      if ($image_info && $image_info[2] > 0 && $image_info[2] < 4 && $auto_thumbs && $image_thumb_file == "" && file_exists($file) && !$no_resize && !file_exists($file_thumb))
        {
          $ok = 0;
          if ($resize_type_thumbs == 1 && ($image_info[0] > $dimension_thumbs || $image_info[1] > $dimension_thumbs))
          {
            $ok = 1;
          }
          elseif ($resize_type_thumbs == 2 && $image_info[0] > $dimension_thumbs)
          {
            $ok = 1;
          }
          elseif ($resize_type_thumbs == 3 && $image_info[1] > $dimension_thumbs)
          {
            $ok = 1;
          }
					if ($ok)
          {
      			if (create_thumbnail($file,	$file_thumb, $quality_thumbs, $dimension_thumbs, $resize_type_thumbs))
            {
		          $log[] = "Created thumbnail.";
		          $image_thumb_file = $image_media_file;
		        }
		        else
            {
        			$log[] = "<u>Error</u> creating thumbnail.";
		        }
					}
		    }
        $sql = "INSERT INTO ".IMAGES_TABLE."
                (cat_id, user_id, image_name, image_description, image_keywords, image_date, image_active, image_media_file, image_thumb_file, image_download_url, image_allow_comments".$additional_field_sql.")
                VALUES
                ($cat_id, $user_id, '$image_name', '$image_description', '$image_keywords', $image_date, $image_active, '$image_media_file', '$image_thumb_file', '$image_download_url', $image_allow_comments".$additional_value_sql.")";
        $result = $site_db->query($sql);
        $image_id = $site_db->get_insert_id();

        if ($result)
        {
          $search_words = array();
          foreach ($search_match_fields as $image_column => $match_column)
          {
            if (isset($HTTP_POST_VARS[$image_column.'_'.$i]))
            {
              $search_words[$image_column] = stripslashes($HTTP_POST_VARS[$image_column.'_'.$i]);
            }
          }
          add_searchwords($image_id, $search_words);
          $log[] = $lang['image_add_success'].": <b><a target=\"4images\" href=\"../details.php?image_id=".$image_id."\">".stripslashes($image_name)."</a></b>";
//ensure that rescaned images wont get same info as already added ones.
          $n++;
        }
        else
        {
          $log[] = "<u>Error</u> adding image!";
        }
        $log[] = "";
        unset($HTTP_POST_VARS['image_name_'.$i]);
        unset($HTTP_POST_VARS['image_media_file_'.$i]);
        unset($HTTP_POST_VARS['image_thumb_file_'.$i]);
        unset($HTTP_POST_VARS['image_name_'.$i]);
        unset($HTTP_POST_VARS['cat_id_'.$i]);
        unset($HTTP_POST_VARS['old_cat_id_'.$i]);
        unset($HTTP_POST_VARS['user_id_'.$i]);
        unset($HTTP_POST_VARS['image_description_'.$i]);
        unset($HTTP_POST_VARS['image_date_'.$i]);
        unset($HTTP_POST_VARS['image_download_url_'.$i]);
        unset($HTTP_POST_VARS['image_keywords_'.$i]);
        unset($HTTP_POST_VARS['image_active_'.$i]);
        unset($HTTP_POST_VARS['image_allow_comments_'.$i]);
        unset($error['image_name_'.$i]);
        unset($error['image_media_file_'.$i]);
        unset($error['image_thumb_file_'.$i]);
        unset($error['image_name_'.$i]);
        unset($error['cat_id_'.$i]);
        unset($error['old_cat_id_'.$i]);
        unset($error['user_id_'.$i]);
        unset($error['image_description_'.$i]);
        unset($error['image_date_'.$i]);
        unset($error['image_download_url_'.$i]);
        unset($error['image_keywords_'.$i]);
        unset($error['image_active_'.$i]);
        unset($error['image_allow_comments_'.$i]);
        if (!empty($additional_image_fields))
        {
          foreach ($additional_image_fields as $key => $val)
          {
            unset($HTTP_POST_VARS[$key.'_'.$i]);
            unset($error[$key.'_'.$i]);
          }
        }
      }
      if (count($log))
      {
        foreach ($log as $val)
        {
          echo $val."<br />";
        }
      }
    }
    if (!$n)
    {
      echo $lang['no_newimages_added'];
    }
    echo "</td>\n</tr>\n</table>\n";
    echo "</td>\n</tr>\n";
    show_table_footer();
    $status = 1;
    $action = "checkimages";
  }
  else
  {
    $msg = sprintf("<span class=\"marktext\">%s</span>", $lang['lostfield_error']);
    $action = "checkimages";
  }
  if (!$rescan)
  {
    unset($HTTP_POST_VARS['action']);
  }
}

if ($action == "checkimages")
{
  $max_dimension = (isset($HTTP_POST_VARS['max_dimension'])) ? $HTTP_POST_VARS['max_dimension'] : $max_dimension_default;
  $cat_id = (isset($HTTP_POST_VARS['cat_id_p'])) ? intval($HTTP_POST_VARS['cat_id_p']) : 0;
  $num_newimages = (isset($HTTP_POST_VARS['num_newimages'])) ? intval($HTTP_POST_VARS['num_newimages']) : $num_newimages_default;
  $detailed = (isset($HTTP_POST_VARS['detailed'])) ? intval($HTTP_POST_VARS['detailed']) : $detailed_default;
  $detailed_checked = ($detailed == 1) ? " checked=\"checked\"" : "";
  $auto_resize = (isset($HTTP_POST_VARS['auto_resize'])) ? intval($HTTP_POST_VARS['auto_resize']) : $auto_resize_default;
  $auto_resize_checked = ($auto_resize == 1) ? " checked=\"checked\"" : "";
  $auto_thumbs = (isset($HTTP_POST_VARS['auto_thumbs'])) ? intval($HTTP_POST_VARS['auto_thumbs']) : $auto_thumbs_default;
  $auto_thumbs_checked = ($auto_thumbs == 1) ? " checked=\"checked\"" : "";
  $auto_iptc = (isset($HTTP_POST_VARS['auto_iptc'])) ? intval($HTTP_POST_VARS['auto_iptc']) : $auto_iptc_default;
  $date_iptc = (isset($HTTP_POST_VARS['date_iptc'])) ? intval($HTTP_POST_VARS['date_iptc']) : $date_iptc_default;
  $dimension = (isset($HTTP_POST_VARS['dimension'])) ? intval($HTTP_POST_VARS['dimension']) : $dimension_default;
  $user_id = (isset($HTTP_POST_VARS['user_id'])) ? intval($HTTP_POST_VARS['user_id']) : $user_info['user_id'];
  $resize_type = (isset($HTTP_POST_VARS['resize_type'])) ? intval($HTTP_POST_VARS['resize_type']) : 1;
  $quality = (isset($HTTP_POST_VARS['quality']) && intval($HTTP_POST_VARS['quality']) && intval($HTTP_POST_VARS['quality']) <= 100) ? intval($HTTP_POST_VARS['quality']) : $quality_default;
  $dimension_thumbs = (isset($HTTP_POST_VARS['dimension_thumbs'])) ? intval($HTTP_POST_VARS['dimension_thumbs']) : $dimension_thumbs_default;
  $resize_type_thumbs = (isset($HTTP_POST_VARS['resize_type_thumbs'])) ? intval($HTTP_POST_VARS['resize_type_thumbs']) : 1;
  $quality_thumbs = (isset($HTTP_POST_VARS['quality_thumbs']) && intval($HTTP_POST_VARS['quality_thumbs']) && intval($HTTP_POST_VARS['quality_thumbs']) <= 100) ? intval($HTTP_POST_VARS['quality_thumbs']) : $quality_thumbs_default;
  $big = (isset($HTTP_POST_VARS['big'])) ? $HTTP_POST_VARS['big'] : $big_default;
  $annotate = (isset($HTTP_POST_VARS['annotate'])) ? $HTTP_POST_VARS['annotate'] : $annotate_default;
  $big_folder = (isset($HTTP_POST_VARS['big_folder'])) ? trim($HTTP_POST_VARS['big_folder']) : $big_folder_default;
  $subcats = (isset($HTTP_POST_VARS['subcats'])) ? trim($HTTP_POST_VARS['subcats']) : $subcats_default;
  $subcats_checked = ($subcats == 1) ? " checked=\"checked\"" : "";
  if ($num_newimages == "" || !$num_newimages)
  {
    $num_newimages = 30;
  }
  show_form_header("checkimages.php", "checkimages");
  show_table_header($lang['nav_images_check'], 2);
  show_input_row($lang['num_newimages_desc'], "num_newimages", $num_newimages);
  show_input_row("Max dimensions for images preview<br /><span class=\"smalltext\">When checked \"Detailed\", image will be resized on your screen acording this value.</span>", "max_dimension", $max_dimension);
//  show_table_separator("IPTC info", 2);
	show_radio_row("Auto insert IPTC values", "auto_iptc", $auto_iptc);
	show_radio_row("Use date from IPTC value", "date_iptc", $date_iptc);
	show_radio_row($lang['detailed_version'], "detailed", $detailed);
  $desc = get_category_dropdown_check($cat_id);
  $desc .= "&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"checkbox\" name=\"subcats\" value=\"1\"".$subcats_checked.">Check subcategories";
 	show_custom_row($desc, "<input type=\"submit\" value=\"".$lang['nav_images_check']."\" class=\"button\">");
  show_table_footer();
  echo "</form>";
}

if (isset($HTTP_POST_VARS['action']) && $action == "checkimages")
{
  if (isset($HTTP_POST_VARS['detailed']) && $HTTP_POST_VARS['detailed'] == 1)
  {
    $detailed = 1;
    $colspan = 2;
  }
  else
  {
    $detailed = 0;
    $colspan = 7;
  }
  $cat_id = (isset($HTTP_POST_VARS['cat_id_p'])) ? intval($HTTP_POST_VARS['cat_id_p']) : 0;
  $cat_id_p = $cat_id;
	$image_list_sql = array();
	$cats = array($cat_id);
  if ($cat_id)
  {
    if ($subcats)
    {
      $sub_cat_cache = $cat_parent_cache;
      get_subcats($cat_id, $cat_id);
    }

	  $image_list_all = array();
    foreach ($cats as $key)
    {
  	  $cat_path = "/".$key;
  	  if ($handle = opendir(MEDIA_PATH.$cat_path))
  	  {
    	  while ($file = @readdir($handle))
        {
    	    if ($file != "." && $file != "..")
          {
    	      if (check_media_type($file))
            {
    	        $image_list_all[$key][] = $file;
    	      }
    	    }
    	  }
    	  closedir($handle);
      }
  	}
    $cat_sql = implode(", ", $cats);
		foreach ($image_list_all as $key => $val)
    {
		  sort($image_list_all[$key]);
		}
	}
	else
	{
    $image_list_all = array();
    $cat_image = array();
	  if ($handle = opendir(MEDIA_PATH))
	  {
  	  while ($file = @readdir($handle))
      {
  	    if ($file != "." && $file != "..")
        {
  	      if (check_media_type($file))
          {
  	  			$image_list_all[0][] = $file;
  	      }
  	    }
  	  }
    	closedir($handle);
    }
		foreach ($image_list_all as $key => $val)
    {
		  sort($image_list_all[$key]);
		}
	  $sql = "SELECT cat_id
	          FROM ".CATEGORIES_TABLE;
	  $result = $site_db->query($sql);
	  while ($row = $site_db->fetch_array($result))
    {
		  $cat_id = $cats[] = $row['cat_id'];
		  $cat_path = ($cat_id == 0) ? "" : "/".$cat_id;
		  if ($handle = opendir(MEDIA_PATH.$cat_path))
		  {
  		  while ($file = @readdir($handle))
        {
  		    if ($file != "." && $file != "..")
          {
  		      if (check_media_type($file))
            {
  		  			$image_list_all[$row['cat_id']][] = $file;
  		      }
  		    }
  		  }
    	  closedir($handle);
      }
		}
		foreach ($image_list_all as $key => $val)
    {
		  sort($image_list_all[$key]);
		}
    $cat_sql = implode(", ", $cats);
	}
  $sql = "SELECT image_media_file, cat_id
          FROM ".IMAGES_TABLE."
          WHERE cat_id IN ($cat_sql)
          ORDER BY cat_id";
  $result = $site_db->query($sql);

  while ($row = $site_db->fetch_array($result))
  {
    $image_list_sql[$row['cat_id']][] = $row['image_media_file'];
  }
	foreach ($image_list_sql as $key => $val)
  {
	  sort($image_list_sql[$key]);
	}

  $image_list = array();
  $image_counter = 0;
	foreach ($image_list_all as $key => $val)
  {
	  for ($i = 0; $i < count($image_list_all[$key]); $i++)
    {
	    if ($image_counter == $num_newimages)
      {
	      break;
	    }
	    if (!@in_array($image_list_all[$key][$i], $image_list_sql[$key]))
      {
	      $image_list[$key][] = $image_list_all[$key][$i];
	      $image_counter++;
	    }
	  }
	}
	foreach ($image_list as $key => $val)
  {
  	sort($image_list[$key]);
	}
  $num_all_newimages = $image_counter;

  if ($msg != "")
  {
    printf("<b>%s</b>\n", $msg);
  }

  show_form_header("checkimages.php", "savenewimages", "form");

  show_table_header("Auto Resizer&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"radio\" name=\"auto_resize\" value=\"1\"".(($auto_resize) ? " checked" : "").">On&nbsp;<input type=\"radio\" name=\"auto_resize\" value=\"\"".(($auto_resize) ? "" : " checked" ).">Off", 2);
  show_input_row($lang['resize_dimension_desc'], "dimension", $dimension);

	$resize = "\n<select name=\"resize_type\">\n";
  foreach ($auto_thumbnail_resize_type_optionlist as $key => $val)
  {
    $resize .= "<option value=\"$key\"";
    if ($resize_type == $key)
    {
      $resize .= " selected=\"selected\"";
    }
    $resize .= ">$val</option>\n";
  }
	$resize .= "</select>\n";
  show_custom_row($lang['resize_proportions_desc'], $resize);

  show_input_row($lang['resize_quality_desc'], "quality", $quality);
	show_radio_row("Save original images", "big", $big);
  show_input_row("Folder name where to save original images", "big_folder", $big_folder);
	show_radio_row("Add annotation (watermark)", "annotate", $annotate);
  show_table_separator("Auto Thumbnailer&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"radio\" name=\"auto_thumbs\" value=\"1\"".(($auto_thumbs) ? " checked" : "").">On&nbsp;<input type=\"radio\" name=\"auto_thumbs\" value=\"\"".(($auto_thumbs) ? "" : " checked" ).">Off", 2);
  show_input_row($lang['convert_thumbnail_dimension'], "dimension_thumbs", $dimension_thumbs);

	$resize = "\n<select name=\"resize_type_thumbs\">\n";
  foreach ($auto_thumbnail_resize_type_optionlist as $key => $val)
  {
    $resize .= "<option value=\"$key\"";
    if ($resize_type_thumbs == $key)
    {
      $resize .= " selected=\"selected\"";
    }
    $resize .= ">$val</option>\n";
  }
	$resize .= "</select>\n";
  show_custom_row($lang['resize_proportions_desc'], $resize);

  show_input_row($lang['convert_thumbnail_quality'], "quality_thumbs", $quality_thumbs);
  if (!$detailed)
  {
    show_table_separator($lang['user'], 2);
	  show_user_select_row("Add as user", $user_id);
  }
  show_table_footer();

  show_hidden_input("cat_id_p", $cat_id_p);
  show_hidden_input("mode", 1);
  show_table_header(preg_replace("/".$site_template->start."num_all_newimages".$site_template->end."/siU", $num_all_newimages, $lang['checkimages_note']), $colspan);

  if ($num_all_newimages)
  {
    show_description_row("<input name=\"allbox\" type=\"checkbox\" onClick=\"CheckAll();\"".(($status) ? "" : " checked=\"checked\"")." /> <b>".$lang['check_all']."</b>", $colspan);
  }
  else
  {
    show_description_row($lang['no_newimages'], $colspan);
  }
  $ii = 0;
	foreach ($image_list as $key => $val)
  {
		$cat_id = $key;
  	$cat_path = ($cat_id == 0) ? "" : "/".$cat_id;
	  $sql = "SELECT cat_id, cat_name
	          FROM ".CATEGORIES_TABLE."
	          WHERE cat_id = $cat_id
	          LIMIT 1";
	  $result = $site_db->query_firstrow($sql);
		$cat_name = $result['cat_name'];
	  for ($i = 1; $i <= count($image_list[$key]); $i++)
    {
	  	 $ii++;
	   //Check Image
	    $file_type = get_file_extension($image_list[$key][$i-1]);
      $auto_iptc_now = ($imageinfo = @getimagesize(MEDIA_PATH.$cat_path."/".$image_list[$key][$i-1], $info) && $auto_iptc) ? 1 : 0;
	    $image_name = get_file_name($image_list[$key][$i-1]);
	    $date = date("Y-m-d H:i:s", time());

	    $thumb_file = 0;
	    if (file_exists(THUMB_PATH.$cat_path."/".$image_name.".jpg"))
      {
	      $thumb_file = $image_name.".jpg";
	    }
	    elseif (file_exists(THUMB_PATH.$cat_path."/".$image_name.".JPG"))
      {
	      $thumb_file = $image_name.".JPG";
	    }
	    elseif (file_exists(THUMB_PATH.$cat_path."/".$image_name.".jpeg"))
      {
	      $thumb_file = $image_name.".jpeg";
	    }
	    elseif (file_exists(THUMB_PATH.$cat_path."/".$image_name.".JPEG"))
      {
	      $thumb_file = $image_name.".JPEG";
	    }
	    elseif (file_exists(THUMB_PATH.$cat_path."/".$image_name.".gif"))
      {
	      $thumb_file = $image_name.".gif";
	    }
	    elseif (file_exists(THUMB_PATH.$cat_path."/".$image_name.".GIF"))
      {
	      $thumb_file = $image_name.".GIF";
	    }
	    elseif (file_exists(THUMB_PATH.$cat_path."/".$image_name.".png"))
      {
	      $thumb_file = $image_name.".png";
	    }
	    elseif (file_exists(THUMB_PATH.$cat_path."/".$image_name.".PNG"))
      {
	      $thumb_file = $image_name.".PNG";
	    }
      $image_name = str_replace("_", " ", $image_name);
      $image_name = str_replace("%20", " ", $image_name);

	    $checked = (isset($HTTP_POST_VARS['image_name_'.$ii]) && (!isset($HTTP_POST_VARS['addimage_'.$ii]) || $HTTP_POST_VARS['addimage_'.$ii] != 1) || $status) ? "" : " checked=\"checked\"";

	    if ($detailed)
      {
	      show_table_separator("<input type=\"checkbox\" name=\"addimage_".$ii."\" value=\"1\"".$checked." /> ".$image_list[$key][$i-1], 2);
	      show_custom_row("Found in", ($cat_name == "" && !$key) ? "[root folder]" : "$cat_name (ID:$key)");
	      if ($file_type == "gif" || $file_type == "jpg"  || $file_type == "png")
        {
	        $file_src = MEDIA_PATH.$cat_path."/".$image_list[$key][$i-1];
          $img_info = @getimagesize($file_src);
          $width = $max_dimension;
          $height = $max_dimension;
          if ($img_info[0] > 0 && $img_info[1] > 0)
          {
        		if ($img_info[0] > $width || $img_info[1] > $height)
            {
        	  	$ratio = $img_info[0] / $img_info[1];
        		  if ($ratio > 1)
              {
        		    $width = $max_dimension;
        		    $height = round(($max_dimension / $img_info[0]) * $img_info[1]);
        		  }
        		  else
              {
        		    $width = round(($max_dimension / $img_info[1]) * $img_info[0]);
        		    $height = $max_dimension;
        		  }
        		}
            else
            {
        			$width = $img_info[0];
        			$height = $img_info[1];
        		}
        	}
	        show_image_row($lang['image']."<br /><span class=\"smalltext\">(".$img_info[0]."x".$img_info[1].")</span>", $file_src, 1, "", $height, $width);
	      }
	      else
        {
	        show_image_row($lang['image'], ICON_PATH."/".$file_type.".gif", 1);
	      }
	      show_hidden_input("image_media_file_".$ii, $image_list[$key][$i-1]);

	      if ($thumb_file)
        {
	        $file_src = THUMB_PATH.$cat_path."/".$thumb_file;
          $img_info = @getimagesize($file_src);
          $width = 48;
          $height = 48;
          $dim = $width;
          if ($img_info[0] > 0 && $img_info[1] > 0)
          {
        		if ($img_info[0] > $width || $img_info[1] > $height)
            {
        	  	$ratio = $img_info[0] / $img_info[1];
        		  if ($ratio > 1)
              {
        		    $width = $dim;
        		    $height = round(($dim / $img_info[0]) * $img_info[1]);
        		  }
        		  else
              {
        		    $width = round(($dim / $img_info[1]) * $img_info[0]);
        		    $height = $dim;
        		  }
        		}
            else
            {
        			$width = $img_info[0];
        			$height = $img_info[1];
        		}
        	}
	        show_image_row($lang['thumb'], $file_src, 1, "", $height, $width);
	        show_hidden_input("image_thumb_file_".$ii, $thumb_file);
	      }
	      else
        {
	        show_custom_row($lang['thumb'], $lang['no_thumb_newimages_ext']);
	        show_hidden_input("image_thumb_file_".$ii, "");
	      }
	      show_input_row($lang['field_download_url'].$lang['download_url_desc'], "image_download_url_".$ii, "", $textinput_size);


	      $image_name = (isset($error['image_name_'.$ii]) && isset($HTTP_POST_VARS['image_name_'.$ii])) ? $HTTP_POST_VARS['image_name_'.$ii] : str_replace("_"," ", $image_name);
        if ($auto_iptc_now)
        {
          if (isset($info['APP13']))
          {
            $iptc = iptcparse($info['APP13']);
            if (is_array($iptc))
            {
              if (isset($iptc['2#005'][0]))
              {
                $image_name = $iptc['2#005'][0];
              }
            }
          }
        }
	      $title = $lang['field_image_name'].((isset($file_src)) ? get_iptc_insert_link($file_src, "object_name", "image_name_".$ii, 0) : "");
	      show_input_row($title, "image_name_".$ii, stripslashes($image_name), $textinput_size);

	      $title = $lang['field_description_ext'].((isset($file_src)) ? get_iptc_insert_link($file_src, "caption", "image_description_".$ii) : "");
        $caption = "";
        if (isset($info['APP13']) && $auto_iptc_now)
        {
          $iptc = iptcparse($info['APP13']);
          if (is_array($iptc))
          {
            $caption = (isset($iptc['2#120'][0])) ? $iptc['2#120'][0] : "";
// Uncomment lines below, to add date into captions
/*
            if (isset($iptc['2#055'][0]))
            {
              $caption .= (($caption != "") ? "\n" : "").$iptc['2#055'][0];
              $caption = preg_replace("/([0-9]{4})([0-9]{2})([0-9]{2})/", "\\1-\\2-\\3", $caption);
            }
*/
          }
        }
        show_textarea_row($title, "image_description_".$i, $caption, $textarea_size);

	      $title = $lang['field_keywords_ext'].((isset($file_src)) ? get_iptc_insert_link($file_src, "keyword", "image_keywords_".$ii) : "");
        $keywords = "";
        if (isset($info['APP13']) && $auto_iptc_now)
        {
          $iptc = iptcparse($info['APP13']);
          if (is_array($iptc))
          {
            if (isset($iptc['2#025']))
            {
              foreach ($iptc['2#025'] as $val)
              {
                $keywords .= (($keywords != "" ) ? " " : "").$val;
              }
            }
          }
        }
        show_textarea_row($title, "image_keywords_".$i, $keywords, $textarea_size);
	      if (isset($error['cat_id_'.$ii]))
        {
			    $title = sprintf("<span class=\"marktext\">%s *</span>", $lang['field_category']);
  			}
        else
        {
  				$title = $lang['field_category'];
  			}
			  echo "<tr class=\"".get_row_bg()."\">\n<td><p class=\"rowtitle\">".$title."</p></td>\n<td>".get_category_dropdown($cat_id, 0, 3, $ii)."</td>\n</tr>\n";

	      show_user_select_row($lang['user'], $user_id, $ii);

        if (isset($info['APP13']) && $date_iptc)
        {
          $iptc = iptcparse($info['APP13']);
          if (is_array($iptc))
          {
             $date = (isset($iptc['2#055'][0])) ? preg_replace("/([0-9]{4})([0-9]{2})([0-9]{2})/", "\\1-\\2-\\3", $iptc['2#055'][0]) : $date;
          }
        }
	      $title = $lang['field_date'].$lang['date_desc'].$lang['date_format'].((isset($file_src)) ? get_iptc_insert_link($file_src, "date_created", "image_date_".$ii, 0) : "");
	      show_input_row($title, "image_date_".$ii, $date, $textinput_size);

	      show_hidden_input("old_cat_id_".$ii, $cat_id);
	      show_radio_row($lang['field_free'], "image_active_".$ii, 1);
	      show_radio_row($lang['field_allow_comments'], "image_allow_comments_".$ii, 1);
	      show_additional_fields("image", array(), IMAGES_TABLE, $ii);
	    }
	    else
      {
	      echo "<tr class=".get_row_bg().">\n";
	      echo "<td><input type=\"checkbox\" name=\"addimage_".$ii."\" value=\"1\"$checked></td>\n";
	      $link = "<a href=\"".MEDIA_PATH.$cat_path."/".$image_list[$key][$i-1]."\" target=\"_blank\">".$image_list[$key][$i-1]."</a>";
	      show_hidden_input("image_media_file_".$ii, $image_list[$key][$i-1]);
	      if ($thumb_file)
        {
	        $file_src = THUMB_PATH.$cat_path."/".$thumb_file;
          $img_info = @getimagesize($file_src);
          $width = 48;
          $height = 48;
          $dim = $width;
          if ($img_info[0] > 0 && $img_info[1] > 0)
          {
        		if ($img_info[0] > $width || $img_info[1] > $height)
            {
        	  	$ratio = $img_info[0] / $img_info[1];
        		  if ($ratio > 1)
              {
        		    $width = $dim;
        		    $height = floor(($dim / $img_info[0]) * $img_info[1]);
        		  }
        		  else
              {
        		    $width = floor(($dim / $img_info[1]) * $img_info[0]);
        		    $height = $dim;
        		  }
        		}
            else
            {
        			$width = $img_info[0];
        			$height = $img_info[1];
        		}
        	}
	        $thumb_status = $lang['thumb_newimages_exists'];
	        $thumb_status .= "<br><img src=\"".$file_src."\" width=\"".$width."\" height=\"".$height."\">";
	        show_hidden_input("image_thumb_file_".$ii, $thumb_file);
	      }
	      else
        {
	        $thumb_status = $lang['no_thumb_newimages'];
          if ($thumbpreview)
          {
	          $thumb_status .= "<br><img src=\"checkimages.php?action=showthumb&mode=".$image_list[$key][$i-1]."&cat_id=".$cat_id."\">";
	        }
	        show_hidden_input("image_thumb_file_".$ii, "");
	      }
	      echo "<td><b>".$link."</b><br />-&raquo; ".$thumb_status."</td>\n";
	      echo "<td>Found in: ".(($cat_name == "" && !$key) ? "[root folder]" : "$cat_name (ID:$key)")."</td>\n";
	      if (isset($error['image_name_'.$ii]))
        {
	        $field_image_name = sprintf("<span class=\"marktext\">%s</span>", $lang['field_image_name']);
	        $image_name = $HTTP_POST_VARS['image_name_'.$ii];
	      }
	      else
        {
	        $field_image_name = $lang['field_image_name'];//sprintf("%s", $lang['field_image_name']);
	        $image_name = (isset($HTTP_POST_VARS['image_name_'.$ii])) ? $HTTP_POST_VARS['image_name_'.$ii] : str_replace("_"," ", $image_name);
          if ($auto_iptc_now)
          {
            if (isset($info['APP13']))
            {
              $iptc = iptcparse($info['APP13']);
              if (is_array($iptc))
              {
                $image_name = (isset($iptc['2#005'][0])) ? $iptc['2#005'][0] : $image_name;
                $caption = (isset($iptc['2#120'][0])) ? $iptc['2#120'][0] : "";
                $keywords = "";
                if (isset($iptc['2#025']))
                {
                  foreach ($iptc['2#025'] as $val)
                  {
                    $keywords .= (($keywords != "" ) ? " " : "").$val;
                  }
                }
                if ($date_iptc)
                {
                  $date = (isset($iptc['2#055'][0])) ? preg_replace("/([0-9]{4})([0-9]{2})([0-9]{2})/", "\\1-\\2-\\3", $iptc['2#055'][0]) : $date;
                }
              }
            }
          }
	      }
	      echo "<td>".$field_image_name.":<br /><input type=\"text\" name=\"image_name_".$ii."\" value=\"".stripslashes($image_name)."\">\n";
				$field_category = $lang['field_category'];
	      if (isset($error['cat_id_'.$ii]))
        {
	        $field_category = sprintf("<span class=\"marktext\">%s</span>", $lang['field_category']);
	      }
	      $cat_id = (isset($HTTP_POST_VARS['cat_id_'.$ii])) ? intval($HTTP_POST_VARS['cat_id_'.$ii]) : $cat_id;
	      echo "<td>".$field_category.":<br />".get_category_dropdown($cat_id, 0, 3, $ii)."</td>\n";
	      show_hidden_input("old_cat_id_".$ii, $cat_id);
	      show_hidden_input("image_description_".$ii, htmlspecialchars($caption));
	      show_hidden_input("image_keywords_".$ii, htmlspecialchars($keywords));
	      show_hidden_input("image_date_".$ii, htmlspecialchars($date));

	      echo "<td>".$lang['field_free'].":<br />";
	      if (isset($HTTP_POST_VARS['image_active_'.$ii]) && $HTTP_POST_VARS['image_active_'.$ii] == 0)
        {
	        $c1 = "";
	        $c2 = " checked=\"checked\"";
	      }
	      else
        {
	        $c1 = " checked=\"checked\"";
	        $c2 = "";
	      }
	      echo "<input type=\"radio\" name=\"image_active_".$ii."\" value=\"1\"".$c1."> ".$lang['yes']."&nbsp;&nbsp;&nbsp;\n";
	      echo "<input type=\"radio\" name=\"image_active_".$ii."\" value=\"0\"".$c2."> ".$lang['no']." ";
	      echo "</td>\n";

	      echo "<td>".$lang['field_allow_comments'].":<br />";
	      if (isset($HTTP_POST_VARS['image_allow_comments_'.$ii]) && $HTTP_POST_VARS['image_allow_comments_'.$ii] == 0)
        {
	        $c1 = "";
	        $c2 = " checked=\"checked\"";
	      }
	      else
        {
	        $c1 = " checked=\"checked\"";
	        $c2 = "";
	      }
	      echo "<input type=\"radio\" name=\"image_allow_comments_".$ii."\" value=\"1\"".$c1."> ".$lang['yes']."&nbsp;&nbsp;&nbsp;\n";
	      echo "<input type=\"radio\" name=\"image_allow_comments_".$ii."\" value=\"0\"".$c2."> ".$lang['no']." ";
	      echo "</td>\n";
	      echo "</tr>\n";
//	      show_hidden_input("user_id_".$ii, $user_id);
	    }
	  }
	}
  if ($num_all_newimages)
  {
  	show_hidden_input("max_dimension", $max_dimension);
  	show_hidden_input("num_newimages", $num_newimages);
    show_hidden_input("detailed", $detailed);
    show_hidden_input("subcats", $subcats);
    show_hidden_input("mode", 1);
    show_form_footer($lang['add'], $lang['reset'], $colspan);
  }
  else
  {
    show_table_footer();
  }
}
show_admin_footer();
?>