<?php
/**************************************************************************
 *                                                                        *
 *    4images - A Web Based Image Gallery Management System               *
 *    ----------------------------------------------------------------    *
 *                                                                        *
 *             File: slideshow.php                                        *
 *        Copyright: (C) 2004 Daniel Janesch                              *
 *            Email: admin@the-deejay.com                                 *
 *              Web: http://www.the-deejay.com                            *
 *         MOD-Name: Slideshow II                                         *
 *    Scriptversion: 1.2                                                  *
 *                                                                        *
 **************************************************************************
 *                                                                        *
 *    Dieses Script ist KEINE Freeware. Bitte lesen Sie die Lizenz-       *
 *    bedingungen (Lizenz.txt) fr weitere Informationen.                 *
 *    ---------------------------------------------------------------     *
 *    This script is NOT freeware! Please read the Copyright Notice       *
 *    (Licence.txt) for further information.                              *
 *                                                                        *
 *************************************************************************/

$templates_used = "slideshow";
$main_template = "slideshow";

define("GET_CACHES", 1);
define("ROOT_PATH", "./");
define("MEDIA_DIR", "data/media");
define("TEMP_MEDIA_DIR", "data/tmp_media");
include(ROOT_PATH."global.php");
require(ROOT_PATH."includes/sessions.php");
require(ROOT_PATH."includes/image_utils.php");
$user_access = get_permission();
include(ROOT_PATH."includes/page_header.php");

if (!$cat_id || !isset($cat_cache[$cat_id]) || !check_permission("auth_viewcat", $cat_id)) {
  header("Location: ".$site_sess->url(ROOT_PATH."index.php", "&"));
  exit;
}

if ($action == "slideshow") {

$txt_clickstream = "";
  if ($cat_id && isset($cat_cache[$cat_id])) {
    $txt_clickstream .= get_category_path($cat_id, 1).$config["category_separator"];
   }
}
$msg = "";

//-----------------------------------------------------
//--- New Slide Show ----------------------------------
//-----------------------------------------------------

$slideshow_id      = $cat_id;
$slideshow_temp_id = TEMP_MEDIA_DIR."/".$slideshow_id."/";
$slideshow_id      = MEDIA_DIR."/".$slideshow_id."/";
$main_template     = "slideshow";
$random_cat_image  = (defined("SHOW_RANDOM_IMAGE") && SHOW_RANDOM_IMAGE == 0) ? "" : get_random_image($cat_id);

$additional_sql = "";
$countit    = 0;
$file_array    = "";
$exclude    = array("mp3","php","gif","1024","800","Thumbs","htm","mpeg","wmv","avi") ;

$additional_sql = "";

$sql = "SELECT i.image_id, i.cat_id, i.user_id, i.image_name, i.image_description, i.image_keywords, "
          ."i.image_date, i.image_active, i.image_media_file, i.image_thumb_file, i.image_download_url, "
          ."i.image_allow_comments, i.image_comments, i.image_downloads, i.image_votes, i.image_rating, "
          ."i.image_hits".$additional_sql.", c.cat_name".get_user_table_field(", u.", "user_name")." "
       ."FROM ".IMAGES_TABLE." i,  ".CATEGORIES_TABLE." c "
       ."LEFT JOIN ".USERS_TABLE." u ON (".get_user_table_field("u.", "user_id")." = i.user_id) "
       ."WHERE i.image_active = 1 AND i.cat_id = $cat_id AND c.cat_id = i.cat_id "
       ."ORDER BY i.image_name ASC" ;

       
$result    = $site_db->query($sql);
$num_rows    = $site_db->get_numrows($result);

if (!$num_rows)  {
   $msg = "<div align=\"center\"> Sorry but there are no suitable images available for a slideshow. <br>Please try another category</div>";
}
else {
// Variables for fullsize:
$max_avail_width = (isset($HTTP_GET_VARS["maw"])) ? intval($HTTP_GET_VARS["maw"]) : $config["slideshow_maxpic"];
$max_avail_height = (isset($HTTP_GET_VARS["mah"])) ? intval($HTTP_GET_VARS["mah"]) : $config["slideshow_maxpic"];
$max_screen_width = (isset($HTTP_GET_VARS["msw"])) ? intval($HTTP_GET_VARS["msw"]) : 0;
$max_screen_height = (isset($HTTP_GET_VARS["msh"])) ? intval($HTTP_GET_VARS["msh"]) : 0;
while ($image_row = $site_db->fetch_array($result))
{
  if (stristr($image_row["image_media_file"],$exclude[0]) || stristr($image_row["image_media_file"],$exclude[1]) ||
      stristr($image_row["image_media_file"],$exclude[2]) || stristr($image_row["image_media_file"],$exclude[3]) ||
      stristr($image_row["image_media_file"],$exclude[4]) || stristr($image_row["image_media_file"],$exclude[5]) ||
      stristr($image_row["image_media_file"],$exclude[6]) || stristr($image_row["image_media_file"],$exclude[7]) ||
      stristr($image_row["image_media_file"],$exclude[8]) || stristr($image_row["image_media_file"],$exclude[9]) ||
      strlen($image_row["image_media_file"]) < 3 )
    continue;
  
  ///////////////////////////////
  // Resizing the images BEGIN //
  ///////////////////////////////

  $sql_image_type = "image_media_file";
  $resize_type = $config["slideshow_proportions"];
  $quality = $config["slideshow_quality"];
  
  // Add the client resolution to the temp directory name:
  $slideshow_temp_id_resolution = $max_screen_width."x".$max_screen_height."/";

  $image_name = $image_row[$sql_image_type];
  $image_file = $slideshow_id . $image_name;
  $image_temp_file = $slideshow_temp_id . $slideshow_temp_id_resolution . "sldshw_" . $image_name;

  if (($config["slideshow_maxpic"] > 0 || $config["slideshow_opennewwindow"] == 2) && !empty($image_name) && file_exists($image_file) &&
      $image_info = getimagesize($image_file)) {
    if ($image_info[2] > 0 && $image_info[2] < 4) {
      if (($resize_type == 0 && ($image_info[0] > $max_avail_width || $image_info[1] > $max_avail_height)) ||
          ($resize_type == 1 && $image_info[0] > $max_avail_width) ||
          ($resize_type == 2 && $image_info[1] > $max_avail_height)) {
        
        checkTempDir ($slideshow_temp_id);
        checkTempDir ($slideshow_temp_id . $slideshow_temp_id_resolution);
        
        // Check if the image was allready processed and is correct:
        if (!file_exists($image_temp_file)) {
          copy($image_file, $image_temp_file);
        } // if !file_exists($image_temp_file)
        if (file_exists($image_temp_file) && $image_temp_info = getimagesize($image_temp_file)) {
          if ($image_temp_info[2] > 0 && $image_temp_info[2] < 4) {
            if (($resize_type == 0 && ($image_temp_info[0] != $max_avail_width || $image_temp_info[1] != $max_avail_height)) ||
                ($resize_type == 1 && $image_temp_info[0] != $max_avail_width) ||
                ($resize_type == 2 && $image_temp_info[1] != $max_avail_height)) {
              copy($image_file, $image_temp_file);
              
              $dimension = $config["slideshow_maxpic"];
              // Should the slideshow open in fullsize:
              if ($config["slideshow_opennewwindow"] == 2) {
                $size_difference_width = $image_temp_info[0] - $max_avail_width;
                $size_difference_height = $image_temp_info[1] - $max_avail_height;
                $dimension = ($size_difference_width > $size_difference_height) ? $max_avail_width : $max_avail_height;
              } // if fullsize
              @set_time_limit(90);
              $convert_options = init_convert_options();
              resize_image($image_temp_file, $quality, $dimension, $resize_type);
            } // if ($resize_type == 0
          } // if $image_temp_info[2] > 0 && $image_temp_info[2] < 4
        } // if file_exists($image_temp_file)
        $image_file = $image_temp_file;
      } // if ($resize_type == 0 &&
    } // if $image_info[2] > 0 && $image_info[2] < 4
  } // if $config["slideshow_maxpic"]
  
  /////////////////////////////
  // Resizing the images END //
  /////////////////////////////
  
  $file_array = $file_array . "\ntheimage[" . $countit++ . "]=[\"" . $countit . "\",\"";
  
  if (stristr($image_name,"http"))
    $file_array = $file_array . $image_name;
  else
    $file_array = $file_array . $image_file;
  
  $file_array = $file_array."\",\"./details.php?image_id=".$image_row["image_id"]."\"];";
} // while

//$file_array = substr("$file_array", 0, -19);
if (!$countit)  {
   $msg = "<div align=\"center\"> Sorry but there are no suitable images available for a slideshow. <br>Please try another category</div>";
}
}


//-----------------------------------------------------
//--- JavaScripts -------------------------------------
//-----------------------------------------------------
$images_to_show = $num_rows;
$start_with = $config["slideshow_start"];
if ($start_with == -1)
  $start_with = $images_to_show - 1;
else if ($start_with == -2)
  $start_with = rand(0, $images_to_show - 1);

$javascript_code = "\n"
  ."// Variables\n"
  ."// duration: ".$config["slideshow_duration"]." ... the duration for one transition\n"
  ."// transition: ".$config["slideshow_transition"]."\n"
  ."var transtype = \"".$config["slideshow_transtype"]."\";\n"
  ."var loopprompt = ".$config["slideshow_loopprompt"]."; // if value = 1 than a message is shown if all pics was viewed\n"
  ."var dotrans = ".$config["slideshow_dotrans"]."; // if value = 1 then there transitions are played in IE\n"
  ."var current = ".$start_with."; // The number of picture where to start\n"
  ."var nextpic = new Image(); // To preload the next image\n"
  ."var newround = 0; // 1 if we did start a new round\n"
  ."var hndl; // The handle for intrevall\n"
  ."var theimage = new Array(); // This array contains all images\n"
  .$file_array."\n"
  ."var theimage_random = theimage; // This array contains all images for random function\n"
  ."var len = ".$images_to_show."; // Contains the length of the images array\n"
  ."var len_random = len; // Same as len but only used for random\n\n"
  ."// Language\n"
  ."var lang_play_slide = \"".$lang["play_slide"]."\";\n"
  ."var lang_pause_slide = \"".$lang["pause_slide"]."\";\n"
  ."var lang_last_pic_reached = \"".$lang["last_pic_reached"]."\";\n"
  ."var lang_first_pic_reached = \"".$lang["first_pic_reached"]."\";\n"
  ."var lang_all_pics_viewed = \"".$lang["all_pics_viewed"]."\";\n\n";


//-----------------------------------------------------
//--- Values for template------------------------------
//-----------------------------------------------------
$field_max_len = strlen($images_to_show."/".$images_to_show);
$current_image_field = "<input class=\"faketext\" type=\"text\" name=\"number\" value=\"".($start_with + 1)."/".$field_max_len."\" 
  size=\"".$field_max_len."\" maxlength=\"".$field_max_len."\">";

// Show only the image:
$first_image_normal = "<img name=\"slideimage\" src=\"\" border=\"0\" style=\"filter:".$config["slideshow_transtype"]."
  (duration=".$config["slideshow_duration"].",transition=".$config["slideshow_transition"].");\">";

// Clicking the image opens the detail in the same winwow:
$detail_same_script = "javascript:window.location.href=theimage[current-1][2];";
$first_image_detail_same = "
  <a href=\"".$detail_same_script."\" title=\"".$lang["show_details"]."\">
    ".$first_image_normal."
  </a>";

// Clicking the image opens the detail in the parent winwow:
$detail_parent_script = "javascript: var url=unescape(theimage[current-1][2]); window.opener.location.href=url; window.close();";
$first_image_detail_parent = "
  <a href=\"".$detail_parent_script."\" title=\"".$lang["show_details"]."\">
    ".$first_image_normal."
  </a>";

$first_image = $first_image_normal;
if ($config["slideshow_clickpicture"] == 1) {
  $first_image = $first_image_detail_same;
} // if $config["slideshow_click_picture"] == 1
else if ($config["slideshow_clickpicture"] == 2) {
  if ($config["slideshow_opennewwindow"] == 1) {
    $first_image = $first_image_detail_parent;
  } // if $config["slideshow_opennewwindow"] == 1
  else {
    $first_image = $first_image_detail_same;
  } // else $config["slideshow_opennewwindow"] == 1
} // else if $config["slideshow_click_picture"] == 2

$stop_play = "<a class=\"paging\" href=\"javascript:startStopSlideshow()\" id=\"startstop\">".$lang["pause_slide"]."</a>";

$first_pic_link = "<a class=\"paging\" href=\"javascript:setCurrent(0);next(1);\" onfocus=\"this.blur()\">".$lang["first_pic"]."</a>";
$prev_pic_link = "<a class=\"paging\" href=\"javascript:setCurrent(-1);next(1);\" onfocus=\"this.blur()\">".$lang["next_pic"]."</a>";
$next_pic_link = "<a class=\"paging\" href=\"javascript:setCurrent(1);next(1);\" onfocus=\"this.blur()\">".$lang["prev_pic"]."</a>";
$last_pic_link = "<a class=\"paging\" href=\"javascript:setCurrent(len-1);next(1);\" onfocus=\"this.blur()\">".$lang["last_pic"]."</a>";


//-----------------------------------------------------
//--- Option Lists ------------------------------------
//-----------------------------------------------------
$order_optionlist = "\n<select name=\"order\" onChange=\"theimage_random = theimage; len_random = len; next()\">\n";
foreach ($slideshow_order_optionlist as $key => $val) {
  $order_optionlist .= "<option value=\"".$key."\"";
  
  if ($config["slideshow_default_order"] == $key)
    $order_optionlist .= " selected=\"selected\"";
  
  $order_optionlist .= ">".$val."</option>\n";
} // foreach slideshow_order_optionlist
$order_optionlist .= "</select>\n\n";

$interval_optionlist = "\n<select name=\"interval\" onChange=\"next()\">\n";
foreach ($slideshow_interval_optionlist as $key => $val) {
  $interval_optionlist .= "<option value=\"".$key."\"";
  
  if ($config["slideshow_default_interval"] == $key)
    $interval_optionlist .= " selected=\"selected\"";
  
  $interval_optionlist .= ">".$val."</option>\n";
} // foreach slideshow_interval_optionlist
$interval_optionlist .= "</select>\n\n";


//-----------------------------------------------------
//--- Clickstream -------------------------------------
//-----------------------------------------------------
$clickstream = "<span class=\"clickstream\"><a href=\"".$site_sess->url(ROOT_PATH."index.php")."\" class=\"clickstream\">".$lang["home"]."</a>".$config["category_separator"].$txt_clickstream."</span>";

//-----------------------------------------------------
//--- Print Out ---------------------------------------
//-----------------------------------------------------
$site_template->register_vars(array(
  "current_image_of" => $current_image_field,
  "image" => $first_image,
  "image_normal" => $first_image_normal,
  "image_detail_same" => $detail_same_script,
  "image_detail_parent" => $first_image_detail_parent,
  "javascript_init" => $javascript_code,
  "order_list" => $order_optionlist,
  "interval_list" => $interval_optionlist,
  "stop_play_button" => $stop_play,
  "first_pic_link" => $first_pic_link,
  "prev_pic_link" => $prev_pic_link,
  "next_pic_link" => $next_pic_link,
  "last_pic_link" => $last_pic_link,
  "slideshow_id" => $slideshow_id,
  "random_cat_image" => $random_cat_image,
  "msg" => $msg,
  "countit" => $countit,
  "clickstream" => $clickstream,
  "lang_control_panel" => $lang["control_panel"]
));

unset($random_cat_image);
unset($file_array);
unset ($countit);

$site_template->print_template($site_template->parse_template($main_template));
include(ROOT_PATH."includes/page_footer.php");


function checkTempDir ($temp_dir) {
  // Check if the directory allready exists:
  if (@is_dir($temp_dir)) {
    @chmod($temp_dir, CHMOD_DIRS);
  } // if @is_dir($temp_dir)
  else {
    $oldumask = umask(0);
    $result = mkdir($temp_dir, CHMOD_DIRS);
    umask($oldumask);
    if (!@is_dir($temp_dir) || !$result) {
      $result = mkdir($temp_dir, 0755);
      @chmod($temp_dir, CHMOD_DIRS);
    } // if !@is_dir($temp_dir) || !$result
  } // else @is_dir($temp_dir))
} // checkTempDir
?> 