/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class BattleChangerMIDlet
extends MIDlet {
    private final BattleChanger canvas = new BattleChanger(this);
    private final Sound sound = new Sound(new byte[4], 5);
    private final Pool pool = new Pool();

    public void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
        this.canvas.start();
    }

    public void pauseApp() {
        this.canvas.stop();
    }

    public void destroyApp(boolean bl) {
        this.canvas.stop();
    }

    public void exitRequested() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void playWAV(String string) {
        byte[] byArray = (byte[])this.pool.get(string);
        if (byArray == null) {
            try {
                int n;
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                byArray = byteArrayOutputStream.toByteArray();
                this.pool.put(byArray, string);
            }
            catch (Exception exception) {
                System.out.println(string + " is not found..");
            }
        }
        try {
            this.sound.stop();
            this.sound.init(byArray, 5);
            this.sound.setGain(this.sound.getGain() / 8);
            this.sound.play(1);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public Image getImage(String string) {
        Image image = (Image)this.pool.get(string);
        if (image == null) {
            try {
                image = Image.createImage((String)("/" + string));
                this.pool.put(image, string);
            }
            catch (IOException iOException) {
                System.out.println(string + " is not found..");
            }
        }
        return image;
    }
}

