/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Drawer {
    public static final int TRANSPARENT = -1;
    public static final int WHITE = -2;
    public static final int LIGHT_GRAY = -3;
    public static final int DARK_GRAY = -4;
    public static final int BLACK = -5;
    public static final int REF_X = 0;
    public static final int REF_Y = 15;

    private static void setColor(Graphics graphics, int n) {
        switch (n) {
            case -1: {
                graphics.setColor(255, 255, 255);
                break;
            }
            case -2: {
                graphics.setColor(255, 255, 255);
                break;
            }
            case -3: {
                graphics.setColor(170, 170, 170);
                break;
            }
            case -4: {
                graphics.setColor(85, 85, 85);
                break;
            }
            case -5: {
                graphics.setColor(0, 0, 0);
                break;
            }
            default: {
                graphics.setColor(n);
            }
        }
    }

    public static int rgbPixel(int n, int n2, int n3) {
        int n4 = n << 16 | n2 << 8 | n3;
        return n4;
    }

    public static void clearScreen(Graphics graphics) {
        int n = graphics.getColor();
        Drawer.setColor(graphics, -2);
        graphics.fillRect(0, 0, GameCanvas.LCD_WIDTH, GameCanvas.LCD_HEIGHT);
        graphics.setColor(n);
    }

    public static void drawImage(Graphics graphics, int n, int n2, Image image) {
        graphics.drawImage(image, 0 + n, n2, 0);
    }

    public static void drawClipImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setClip(0 + n, n2, n3, n4);
        graphics.drawImage(image, 0 + n - n5, n2 - n6, 0);
        graphics.setClip(0, 0, GameCanvas.LCD_WIDTH, GameCanvas.LCD_HEIGHT);
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        graphics.drawString(string, 0 + n, n2, n3);
    }

    public static void drawString(Graphics graphics, String string, int n, int n2) {
        Drawer.drawString(graphics, string, n, n2, 0);
    }

    public static void drawString(Graphics graphics, int n, int n2, int n3, int n4, String string) {
        int n5 = graphics.getColor();
        Drawer.setColor(graphics, n3);
        graphics.drawString(0 + string, n, n2, 0);
        graphics.setColor(n5);
    }

    public static void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = graphics.getColor();
        Drawer.setColor(graphics, n5);
        graphics.drawRect(0 + n, n2, n3 - 1, n4 - 1);
        graphics.setColor(n6);
    }

    public static void drawFillRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = graphics.getColor();
        Drawer.setColor(graphics, n5);
        graphics.fillRect(0 + n, n2, n3, n4);
        graphics.setColor(n6);
    }

    public static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = graphics.getColor();
        Drawer.setColor(graphics, n5);
        graphics.drawLine(0 + n, n2, 0 + n3, n4);
        graphics.setColor(n6);
    }
}

