/*
 * Decompiled with CFR 0.152.
 */
public class Float {
    public static final Float E;
    private static final Float ERROR;
    private static final int ITNUM = 5;
    public static final Float LOG10;
    public static final Float ONE;
    public static final Float PI;
    public static final Float PIdiv12;
    public static final Float PIdiv2;
    public static final Float PIdiv4;
    public static final Float PIdiv6;
    public static final Float PImul2;
    public static final Float PImul4;
    public static final Float SQRT3;
    public static final Float ZERO;
    public long m_E;
    public long m_Val;
    private long maxLimit = 92233720368547758L;

    static {
        ERROR = new Float(Long.MIN_VALUE, Long.MIN_VALUE);
        SQRT3 = new Float(1732050807568877294L, -18L);
        PI = new Float(3141592653589793238L, -18L);
        ZERO = new Float();
        ONE = new Float(1L);
        E = new Float(271828182845904512L, -17L);
        LOG10 = new Float(2302585092994045684L, -18L);
        PIdiv2 = PI.Div(2L);
        PIdiv4 = PIdiv2.Div(2L);
        PIdiv6 = PIdiv2.Div(3L);
        PIdiv12 = PIdiv6.Div(2L);
        PImul2 = PI.Mul(2L);
        PImul4 = PI.Mul(4L);
    }

    public Float(Float value) {
        this.m_Val = value.m_Val;
        this.m_E = this.m_Val == 0L ? 0L : value.m_E;
    }

    public Float(long value, long e) {
        this.m_Val = value;
        this.m_E = this.m_Val == 0L ? 0L : e;
    }

    public Float(long value) {
        this.m_Val = value;
        this.m_E = 0L;
    }

    public Float() {
        this.m_E = 0L;
        this.m_Val = 0L;
    }

    public Float Add(Float value) {
        if (value.Equal(ZERO)) {
            return new Float(this);
        }
        long e1 = this.m_E;
        long e2 = value.m_E;
        long v1 = this.m_Val;
        long v2 = value.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        if (v1 > 0L && v2 > Long.MAX_VALUE - v1 || v1 < 0L && v2 < Long.MIN_VALUE - v1) {
            v1 /= 10L;
            ++e1;
            v2 /= 10L;
            ++e2;
        }
        if (v1 > 0L && v2 > Long.MAX_VALUE - v1) {
            return new Float(ERROR);
        }
        if (v1 < 0L && v2 < Long.MIN_VALUE - v1) {
            return new Float(ERROR);
        }
        return new Float(v1 + v2, e1);
    }

    public Float Div(Float value) {
        if (value.Equal(ONE)) {
            return new Float(this);
        }
        long e1 = this.m_E;
        long e2 = value.m_E;
        long v1 = this.m_Val;
        if (v1 == 0L) {
            return new Float(ZERO);
        }
        long v2 = value.m_Val;
        if (v2 == 0L) {
            return new Float(ERROR);
        }
        long val = 0L;
        while ((v1 %= v2) != 0L && Math.abs(val += v1 / v2) <= 0xCCCCCCCCCCCCCCCL) {
            if (Math.abs(v1) > 0xCCCCCCCCCCCCCCCL) {
                v2 /= 10L;
                ++e2;
            } else {
                v1 *= 10L;
                --e1;
            }
            val *= 10L;
        }
        Float f = new Float(val, e1 - e2);
        f.RemoveZero();
        return f;
    }

    public Float Div(long value) {
        return this.Div(new Float(value, 0L));
    }

    /*
     * Unable to fully structure code
     */
    public boolean Equal(Float x) {
        e1 = this.m_E;
        e2 = x.m_E;
        v1 = this.m_Val;
        v2 = x.m_Val;
        if (v1 == 0L && v2 == 0L || v1 == v2 && e1 == e2) {
            return true;
        }
        if (Math.abs(e1 - e2) <= 20L) ** GOTO lbl31
        return false;
lbl-1000:
        // 1 sources

        {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
lbl31:
            // 6 sources

            ** while (e1 != e2)
        }
lbl32:
        // 1 sources

        return v1 == v2;
    }

    public static Float Frac(Float x) {
        long tmpVal = x.m_Val;
        if (x.m_E < 0L) {
            long coeff = 1L;
            if (x.m_E > -19L) {
                long i = 0L;
                while (i < -x.m_E) {
                    coeff *= 10L;
                    ++i;
                }
                tmpVal /= coeff;
                tmpVal *= coeff;
                tmpVal = x.m_Val - tmpVal;
            } else {
                return ZERO;
            }
        }
        return new Float(tmpVal, x.m_E);
    }

    public boolean Great(Float x) {
        long e1 = this.m_E;
        long e2 = x.m_E;
        long v1 = this.m_Val;
        long v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        return v1 > v2;
    }

    public static Float Int(Float x) {
        long tmpVal = x.m_Val;
        if (x.m_E < 0L) {
            long coeff = 1L;
            if (x.m_E > -19L) {
                long i = 0L;
                while (i < -x.m_E) {
                    coeff *= 10L;
                    ++i;
                }
                tmpVal /= coeff;
                tmpVal *= coeff;
            } else {
                return ZERO;
            }
        }
        return new Float(tmpVal, x.m_E);
    }

    public static Float Int2(Float x) {
        long tmpVal = x.m_Val;
        if (x.m_E < 0L) {
            long coeff = 1L;
            if (x.m_E > -19L) {
                long i = 0L;
                while (i < -x.m_E) {
                    coeff *= 10L;
                    ++i;
                }
                tmpVal /= coeff;
            } else {
                return ZERO;
            }
        }
        return new Float(tmpVal, x.m_E);
    }

    public boolean Less(Float x) {
        long e1 = this.m_E;
        long e2 = x.m_E;
        long v1 = this.m_Val;
        long v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        return v1 < v2;
    }

    public boolean Less(long x) {
        return this.Less(new Float(x, 0L));
    }

    public Float Mul(Float value) {
        boolean negative2;
        boolean negative1;
        if (value.Equal(ZERO) || this.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (value.Equal(ONE)) {
            return new Float(this);
        }
        boolean bl = negative1 = this.m_Val < 0L;
        if (negative1) {
            this.m_Val = -this.m_Val;
        }
        boolean bl2 = negative2 = value.m_Val < 0L;
        if (negative2) {
            value.m_Val = -value.m_Val;
        }
        while (true) {
            if (value.m_Val > this.m_Val) {
                if (Long.MAX_VALUE / this.m_Val >= value.m_Val) break;
                value.m_Val /= 10L;
                ++value.m_E;
                continue;
            }
            if (Long.MAX_VALUE / value.m_Val >= this.m_Val) break;
            this.m_Val /= 10L;
            ++this.m_E;
        }
        if (negative1) {
            this.m_Val = -this.m_Val;
        }
        if (negative2) {
            value.m_Val = -value.m_Val;
        }
        long e = this.m_E + value.m_E;
        long v = this.m_Val * value.m_Val;
        return new Float(v, e);
    }

    public Float Mul(long value) {
        return this.Mul(new Float(value, 0L));
    }

    public Float Neg() {
        return new Float(-this.m_Val, this.m_E);
    }

    /*
     * Unable to fully structure code
     */
    public void RemoveZero() {
        if (this.m_Val != 0L) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            this.m_Val /= 10L;
            ++this.m_E;
lbl6:
            // 2 sources

            ** while (this.m_Val % 10L == 0L)
        }
lbl7:
        // 1 sources

    }

    public Float Sub(Float value) {
        if (value.Equal(ZERO)) {
            return new Float(this.m_Val, this.m_E);
        }
        return this.Add(new Float(-value.m_Val, value.m_E));
    }

    public static Float abs(Float x) {
        if (x.m_Val < 0L) {
            return x.Neg();
        }
        return new Float(x);
    }

    public static Float acos(Float x) {
        return PIdiv2.Sub(Float.asin(x));
    }

    public static Float asin(Float x) {
        if (x.Less(ONE.Neg()) || x.Great(ONE)) {
            return new Float(ERROR);
        }
        if (x.Equal(ONE.Neg())) {
            return PIdiv2.Neg();
        }
        if (x.Equal(ONE)) {
            return PIdiv2;
        }
        return Float.atan(x.Div(Float.sqrt(ONE.Sub(x.Mul(x)))));
    }

    public static Float atan(Float x) {
        Float a;
        boolean signChange = false;
        boolean Invert = false;
        int sp = 0;
        if (x.Less(ZERO)) {
            x = x.Neg();
            signChange = true;
        }
        if (x.Great(ONE)) {
            x = ONE.Div(x);
            Invert = true;
        }
        while (x.Great(PIdiv12)) {
            ++sp;
            a = x.Add(SQRT3);
            a = ONE.Div(a);
            x = x.Mul(SQRT3);
            x = x.Sub(ONE);
            x = x.Mul(a);
        }
        Float x2 = x.Mul(x);
        a = x2.Add(new Float(14087812L, -7L));
        a = new Float(55913709L, -8L).Div(a);
        a = a.Add(new Float(60310579L, -8L));
        a = a.Sub(x2.Mul(new Float(5160454L, -8L)));
        a = a.Mul(x);
        while (sp > 0) {
            a = a.Add(PIdiv6);
            --sp;
        }
        if (Invert) {
            a = PIdiv2.Sub(a);
        }
        if (signChange) {
            a = a.Neg();
        }
        return a;
    }

    public static Float atan2(Float x, Float y) {
        if (y.Equal(ZERO)) {
            return new Float(ERROR);
        }
        Float f = Float.atan(x.Div(y));
        if (x.m_Val > 0L && y.m_Val < 0L) {
            f = f.Add(PI);
        }
        if (x.m_Val < 0L && y.m_Val < 0L) {
            f = f.Sub(PI);
        }
        return f;
    }

    public static Float ceil(Float x) {
        long tmpVal = x.m_Val;
        if (x.m_E < 0L) {
            long coeff = 1L;
            if (x.m_E > -19L) {
                long i = 0L;
                while (i < -x.m_E) {
                    coeff *= 10L;
                    ++i;
                }
                tmpVal /= coeff;
                if (x.m_Val - (tmpVal *= coeff) > 0L) {
                    tmpVal += coeff;
                }
            } else {
                if (tmpVal > 0L) {
                    return ONE;
                }
                return ZERO;
            }
        }
        return new Float(tmpVal, x.m_E);
    }

    public static Float cos(Float x) {
        while (x.Great(PI)) {
            x = x.Sub(PImul2);
        }
        while (x.Less(PI.Neg())) {
            x = x.Add(PImul2);
        }
        Float m1 = x.Mul(x);
        Float q1 = m1.Div(2L);
        Float m2 = m1.Mul(m1);
        Float q2 = m2.Div(24L);
        Float m3 = m1.Mul(m2);
        Float q3 = m3.Div(720L);
        Float m4 = m2.Mul(m2);
        Float q4 = m4.Div(40320L);
        Float m5 = m4.Mul(m1);
        Float q5 = m5.Div(3628800L);
        Float m6 = m5.Mul(m1);
        Float q6 = m6.Div(479001600L);
        Float m7 = m6.Mul(m1);
        Float q7 = m7.Div(479001600L);
        q7 = q7.Div(182L);
        Float result = ONE.Sub(q1).Add(q2).Sub(q3).Add(q4).Sub(q5).Add(q6).Sub(q7);
        if (result.Less(new Float(-999999L, -6L))) {
            return ONE.Neg();
        }
        if (result.Great(new Float(999999L, -6L))) {
            return new Float(ONE);
        }
        if (result.Great(new Float(-5L, -4L)) && result.Less(new Float(5L, -4L))) {
            return new Float(ZERO);
        }
        return result;
    }

    public static Float floor(Float x) {
        long tmpVal = x.m_Val;
        if (x.m_E < 0L) {
            long coeff = 1L;
            if (x.m_E > -19L) {
                long i = 0L;
                while (i < -x.m_E) {
                    coeff *= 10L;
                    ++i;
                }
                tmpVal /= coeff;
                if (x.m_Val - (tmpVal *= coeff) < 0L) {
                    tmpVal -= coeff;
                }
            } else {
                if (tmpVal < 0L) {
                    return ONE.Neg();
                }
                return ZERO;
            }
        }
        return new Float(tmpVal, x.m_E);
    }

    public boolean isError() {
        return this.m_Val == Float.ERROR.m_Val && this.m_E == Float.ERROR.m_E;
    }

    public static Float sin(Float x) {
        while (x.Great(PI)) {
            x = x.Sub(PImul2);
        }
        while (x.Less(PI.Neg())) {
            x = x.Add(PImul2);
        }
        Float m1 = x.Mul(x.Mul(x));
        Float q1 = m1.Div(6L);
        Float m2 = x.Mul(x.Mul(m1));
        Float q2 = m2.Div(120L);
        Float m3 = x.Mul(x.Mul(m2));
        Float q3 = m3.Div(5040L);
        Float m4 = x.Mul(x.Mul(m3));
        Float q4 = m4.Div(362880L);
        Float m5 = x.Mul(x.Mul(m4));
        Float q5 = m5.Div(39916800L);
        Float m6 = x.Mul(x.Mul(m5));
        Float q6 = m6.Div(39916800L);
        q6 = q6.Div(156L);
        Float m7 = x.Mul(x.Mul(m6));
        Float q7 = m7.Div(39916800L);
        q7 = q7.Div(32760L);
        Float result = x.Sub(q1).Add(q2).Sub(q3).Add(q4).Sub(q5).Add(q6).Sub(q7);
        if (result.Less(new Float(-999999L, -6L))) {
            return new Float(-1L);
        }
        if (result.Great(new Float(999999L, -6L))) {
            return new Float(1L);
        }
        if (result.Great(new Float(-5L, -4L)) && result.Less(new Float(5L, -4L))) {
            return new Float(0L);
        }
        return result;
    }

    public static Float sqrt(Float x) {
        int sp = 0;
        boolean inv = false;
        if (x.Less(ZERO)) {
            return new Float(ERROR);
        }
        if (x.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (x.Equal(ONE)) {
            return new Float(ONE);
        }
        if (x.Less(ONE)) {
            x = ONE.Div(x);
            inv = true;
        }
        long e = x.m_E / 2L;
        Float tmp = new Float(x.m_Val, x.m_E - e * 2L);
        while (tmp.Great(new Float(16L))) {
            ++sp;
            tmp = tmp.Div(16L);
        }
        Float a = new Float(2L);
        int i = 5;
        while (i > 0) {
            Float b = tmp.Div(a);
            a = a.Add(b);
            a = a.Div(2L);
            --i;
        }
        while (sp > 0) {
            --sp;
            a = a.Mul(4L);
        }
        a.m_E += e;
        if (inv) {
            a = ONE.Div(a);
        }
        return a;
    }

    public static Float tan(Float x) {
        Float c = Float.cos(x);
        if (c.Equal(ZERO)) {
            return new Float(ERROR);
        }
        return Float.sin(x).Div(c);
    }

    public long toLong() {
        long tmpE = this.m_E;
        long tmpVal = this.m_Val;
        while (tmpE != 0L) {
            if (tmpE < 0L) {
                tmpVal /= 10L;
                ++tmpE;
                continue;
            }
            tmpVal *= 10L;
            --tmpE;
        }
        return tmpVal;
    }

    public String toShortString() {
        if (this.isError()) {
            return "NaN";
        }
        Long l = new Long(this.m_Val);
        String str = l.toString();
        int len = str.length() + (int)this.m_E;
        if (this.m_Val < 0L ? len > 1 : len > 0) {
            return str.substring(0, len);
        }
        return "0";
    }

    public String toString() {
        if (this.isError()) {
            return "NaN";
        }
        this.RemoveZero();
        Long l = new Long(this.m_Val);
        String str = l.toString();
        int len = str.length();
        boolean neg = false;
        if (this.m_Val < 0L) {
            neg = true;
            str = str.substring(1, len);
            --len;
        }
        StringBuffer sb = new StringBuffer();
        if (this.m_E < 0L) {
            int absE = (int)Math.abs(this.m_E);
            if (absE < len) {
                sb.append(str.substring(0, len - absE));
                sb.append(".");
                sb.append(str.substring(len - absE));
            } else {
                sb.append(str);
                int i = 0;
                while (i < absE - len) {
                    sb.insert(0, "0");
                    ++i;
                }
                sb.insert(0, "0.");
            }
        } else if ((long)len + this.m_E > 6L) {
            sb.append(str.charAt(0));
            if (str.length() > 1) {
                sb.append(".");
                sb.append(str.substring(1));
            } else {
                sb.append(".0");
            }
            sb.append("E" + ((long)(len - 1) + this.m_E));
        } else {
            sb.append(str);
            int i = 0;
            while ((long)i < this.m_E) {
                sb.append("0");
                ++i;
            }
        }
        str = sb.toString();
        sb = null;
        if (neg) {
            str = "-" + str;
        }
        return str;
    }
}

