<?php
//***************************************************************************//
//                                                                           //
//  Program Name    	: vCard PRO                                          //
//  Program Version     : 2.9                                                //
//  Program Author      : Joao Kikuchi,  Belchior Foundry                    //
//  Home Page           : http://www.belchiorfoundry.com                     //
//  Retail Price        : $80.00 United States Dollars                       //
//  WebForum Price      : $00.00 Always 100% Free                            //
//  Supplied by         : South [WTN]                                        //
//  Nullified By        : CyKuH [WTN]                                        //
//  Distribution        : via WebForum, ForumRU and associated file dumps    //
//                                                                           //
//                (C) Copyright 2001-2003 Belchior Foundry                   //
//***************************************************************************//
define('SMTP_INCLUDED', 1);
define('SMTP_STATUS_NOT_CONNECTED', 1, true);
define('SMTP_STATUS_CONNECTED', 2, true);
define('CRLF',"\r\n");
class SMTP_Class {
	var $debug = false;
	var $line_wrap = 75;
	var $authenticated	= false;
	var $timeout = 20;
	var $smtp_host = 'localhost';
	var $smtp_username = '';
	var $smtp_password = '';
	var $smtp_port = 25;
	var $status = '';
	var $auth = false;
	var $reporterror = true;
	var $errors = '';
	var $parts = array();
	var $attach = array();

	function SMTP_Class($charset='iso-8859-1',$ctype='text/plain') {
		$this->set_var('charset',$charset);
		$this->set_var('ctype',$ctype);
	}
	function init(){
		$this->connect();
		$this->auth();
	}
	function set_var($name,$value) {
		$this->$name = $value;
	}
	
	function &connect() {
		$this->debuger("Connecting to SMTP server ' $this->smtp_host '. ");
		if(!isset($this->status))
		{
			$obj = new SMTP_Class($params);
			if($obj->connect())
			{
				$obj->status = SMTP_STATUS_CONNECTED;
			}
			return $obj;
		}else{
			if($this->socketconnection = @fsockopen($this->smtp_host,$this->smtp_port,$errno,&$errstr,$this->timeout))
			{
				if(function_exists('socket_set_timeout'))
				{
					@socket_set_timeout($this->socketconnection, 5, 0);
				}
			}else{
				$this->errors .= "couldn't connect to SMTP mail server ".$this->smtp_host."\n";
				$this->stop("Couldn't Connect", __LINE__, __FILE__);
			}
    	}
		$this->server_result($this->socketconnection,'220');
	}
	
	function auth() {
		$this->debuger("Authenticating to SMTP server.");
		if( !empty($this->smtp_username) && !empty($this->smtp_password) )
		{
			$this->send_data("EHLO " . $this->smtp_host,'250');
			$this->send_data("AUTH LOGIN",'334');
			$this->send_data(base64_encode($this->smtp_username),'334');
			$this->send_data(base64_encode($this->smtp_password),'235');
			$this->authenticated = true;
		}else{
			$this->send_data("HELO " . $this->smtp_host,'250');// Send the RFC821 specified HELO.
		}
	}
	function close(){
		$this->debuger("Closing the connection to SMTP server: ' $this->smtp_host '. ");
		if ($this->socketconnection)
		{
			fputs($this->socketconnection, "QUIT\r\n");
			fclose($this->socketconnection);
			$this->status = SMTP_STATUS_NOT_CONNECTED;
			$this->socketconnection=0;
		}
	}
	
	function smtpmail($to_email, $from_email, $subject, $message) {
		if($this->is_connected())
		{
			if($this->auth && !$this->authenticated)
			{
				if(!$this->auth())
				return false;
			}
		}
		if(is_array($message))
		{
			$this->parts[] = array ('ctype'=> $message['ctype'],
                                  'message'=> $message['message'],
                                     'name'=> $message['name']);
			$this->debuger("Creating parts[] array ") ;
			$formatted_body = $this->build_multipart();
		}else{
			$parts =  array(  'ctype'=> $this->ctype,
							'message'=> $message,
							   'name'=> '');
			$formatted_body = $this->build_message($parts);
		}
		$this->debuger("Sending e-mail.");
		$headers = $this->build_headers($to_email,$from_email,$subject);
		$this->send_data("MAIL FROM: <" . $from_email . ">",250);
		$this->send_data("RCPT TO: <". $to_email .">",250);
		$this->send_data("DATA" ,354);
		$this->send_data($headers);
		$this->send_data($formatted_body);
		$this->send_data(".",250);
		$this->clear_rcpt();
		return true;
	}

	function build_headers($to_email,$from_email,$subject){
		
        $headers  = "From: <". $from_email .">\r\n";
        $headers .= "To: <". $to_email .">\r\n";
        $headers .= "Reply-To: <". $from_email . ">\r\n";
        $headers .= "Subject: ". $subject . "\r\n";
		$headers .= "MIME-Version: 1.0". "\r\n";
		$headers .= "X-Priority: 3\r\n";
		$headers .= "X-MSMail-Priority: Normal\r\n";
		$headers .= "X-Mailer: PHP/".phpversion(); 	// mailer
    	return $headers;
	}
	function send_data($command,$expect='') {
		$this->debuger("sending: $command \n exp: [$exp_result] ");
		fputs($this->socketconnection, $command . "\r\n");
		if(!empty($expect))
		{
			$this->server_result($this->socketconnection,$expect);
		}
	}
	function attach_file($source,$c_type,$f_name) {
		$this->parts[] = array ('ctype'    => $c_type,
                                'message'  => $source,
                                'name'     => $f_name);
	}
	function build_multipart(){
		$boundary = 'next'.md5(time());
		$multipart = "Content-Type: multipart/mixed; boundary=\"$boundary\"\r\n\r\nThis is a MIME encoded message.\r\n\r\n--$boundary";
		for($i=sizeof($this->parts)-1; $i>=0; $i--)
		{
        	$multipart .= "\r\n". $this->build_message($this->parts[$i])."--".$boundary."";
		}
		return $multipart .= "--\r\n";
	}
	function build_message($part) {
		$this->debuger("building message:");
		if($part['ctype']=='text/plain' || $part['ctype']=='text/html')
		{
	        $msg = $this->wrap_text($part['message']);
			$encoding = '';
			$charset = $this->charset;
	        return "Content-Type: ".$part['ctype'].
					( !empty($charset)? "; charset=\"". $charset."\"\r\n\r\n" : '' ) .
				$msg."\n";
		}else{
			$msg = empty($this->attach[$part['message']])? $this->encode_file($part['message']) : $this->attach[$part['message']]['encoded'];
			$encoding = 'base64';
			$charset = '';
			$part['ctype'] = empty($part['ctype'])? $this->get_type($part['message']) : $part['ctype'];
        return "Content-Type: ".$part['ctype'].
				( !empty($part['name'])? "; name=\"".$part['name']."\"\n" : "\n" ) .
				( !empty($encoding)? "Content-Transfer-Encoding: ". $encoding ."\n" :"" ) .
				$msg."\n";
		}
    	unset($msg);
		unset($encoding);
		unset($charset);
	}
	function message_type($type) {
		$type = strtolower($type);
		switch($type)
		{
			case 'html':
				$this->ctype = 'text/html';
				break;
			default:
				$this->ctype = 'text/plain';
				break;
		}
	}
	function get_type($file_type) {
		$type = strtolower($file_type);
		switch(strrchr($file_type,'.'))
		{
			case '.gif':
				return 'image/gif';
				break;
			case '.jpg':
				return "image/jpeg";
				break;
			case '.jpeg':
				return "image/jpeg";
				break;
			case '.png':
				return "image/png";
				break;
			case '.gz':
				return 'application/x-gzip';
				break;
			case '.htm':
				return 'text/html';
				break;
			case '.html':
				return 'text/html';
				break;
			case '.tar':
				return 'application/x-tar';
				break;
			case '.txt':
				return 'text/plain';
				break;
			case '.doc':
				return 'application/msword';
				break;
			case '.zip':
				return "application/zip";
				break;
			default:
				return "application/octet-stream";
				break;
		}
    }
	function wrap_text($msg) {
		return wordwrap($msg, $this->line_wrap,"\r\n");
	}
	function encode_file($file){
		if (is_readable($file))
		{
			$fd = fopen($file,'r');
			$content = fread($fd,filesize($file));
			$encoded = chunk_split(base64_encode($content)); // format $data using RFC 2045 semantics
			fclose($fd);
			$this->attach[$file] = array('ctype' => $this->get_type($file),
										'encoded' => $encoded,
										'name' => $file);
		}else{
			$this->errors .= "Unreadable file: ".$file.", check if file is available and/or permissions.\n";
			$this->stop("Couldn't load file", __LINE__, __FILE__);
		}
		return $encoded;
	}
	function server_result($socket, $response) {
		while(substr($server_response,3,1)!=' ')
		{
			if(!($server_response=fgets($socket,256)) )
			{
				$this->stop("Couldn't receive smtp server response codes", __LINE__, __FILE__);
			}
		}
		if( !(substr($server_response,0,3)==$response))
		{
			$this->stop("Problems sending Mail.\n Response: $server_response", __LINE__, __FILE__); 
		}
	}
	function is_connected() {
		return (is_resource($this->socketconnection) && ($this->status === SMTP_STATUS_CONNECTED));
	}
	function stop($msg,$line,$file) {
		if ($this->reporterror)
		{
			$message  = "SMTP Class Error:\n$msg\n";
			$message .= "Error(s): <strong> ". $this->errors ." </strong>\n";
			$message .= !empty($errstr)? "$errstr ($errno)\n" : '';
			$message .= "Date: " . date('Y/m/d - h:i:s A') . "\n";
			$message .= "Script: " . getenv('SCRIPT_NAME') . "\n";
			$message .= "Referer: " . getenv('HTTP_REFERER') . "\n";
			$message .= "File: " . $file . "\n";
			$message .= "Line: " . $line . "\n";
			echo "</td></tr></table>\n<p>\n<pre>\n$message \n";
			//      echo "\n<!-- $message -->\n";
			die();
		}
	}
	function clear_all() {
		$this->parts = array();
		$this->attach = array();
	}
	function clear_rcpt() {
		$this->parts = array();
	}
	function debuger($msg) {
		if ($this->debug)
		{
			print "<hr><pre>\n".$msg."\n</pre>";
		}
	}
}
?>